% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_summary.R
\name{summary.lyl}
\alias{summary.lyl}
\title{Summarize Life Years Lost at one specific age}
\usage{
\method{summary}{lyl}(object, decimals = 2, difference = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{lyl} (obtained with function \code{lyl}).}

\item{decimals}{Number of decimals to be reported (default is 2).}

\item{difference}{Parameter automatically created by the package.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A table with the summary of the results.
}
\description{
\code{summary} for objects of class \code{lyl} summarizes Life Years Lost
at one specific age.
}
\examples{
# Load simulated data as example
data(simu_data)

# Estimate remaining life expectancy and Life Years
# Lost after age 45 years and before age 95 years
lyl_estimation <- lyl(data = simu_data, t = age_death, status = death,
                      age_specific = 45, tau = 95)

# Summarize and plot the data
summary(lyl_estimation)

}
\seealso{
\itemize{
    \item{\code{\link{lyl}} for estimation of Life Years Lost at one specific age.}
}

% @references \itemize{
    % \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition. \emph{In preparation}.}
% }
}
