% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.detection.R
\name{raster2Cimg}
\alias{raster2Cimg}
\title{RasterLayer to Cimg conversion}
\usage{
raster2Cimg(rasterLayer, NA.replace = 0, maxpixels = 1e+10)
}
\arguments{
\item{rasterLayer}{raster object. raster of canopy height model, preferably filtered to avoid effect of holes on volume and surface computation}

\item{NA.replace}{numeric. value to replace NA values with.}

\item{maxpixels}{numeric. maximum number of pixels to be converted to cimg (argument passed to as.cimg).}
}
\value{
A cimg object
}
\description{
converts a RasterLayer object to Cimg object. NA values in raster are replaced.
}
\examples{
data(chmchablais3)

chm.cim <- raster2Cimg(chmchablais3)
chm.cim
summary(chm.cim)

# plot rasterLayer
raster::plot(chmchablais3)

# plot cimg object
plot(chm.cim)
}
\seealso{
\code{\link{cimg2Raster}}
}
