% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-LAS.R, R/methods-LAScatalog.R,
%   R/methods-LASheader.R
\name{Extract}
\alias{Extract}
\alias{$,LAS-method}
\alias{[[,LAS,ANY,missing-method}
\alias{$<-,LAS-method}
\alias{[[<-,LAS,ANY,missing-method}
\alias{[,LAS,numeric,ANY-method}
\alias{[,LAS,logical,ANY-method}
\alias{[,LAS,sf,ANY-method}
\alias{[,LAS,sfc,ANY-method}
\alias{$,LAScatalog-method}
\alias{[[,LAScatalog,ANY,missing-method}
\alias{[,LAScatalog,ANY,ANY-method}
\alias{[,LAScatalog,logical,ANY-method}
\alias{[,LAScatalog,sf,ANY-method}
\alias{[,LAScatalog,sfc,ANY-method}
\alias{[[<-,LAScatalog,ANY,ANY-method}
\alias{$<-,LAScatalog-method}
\alias{$,LASheader-method}
\alias{$<-,LASheader-method}
\alias{[[,LASheader,ANY,missing-method}
\alias{[[<-,LASheader,character,missing-method}
\title{Extract or Replace Parts of a LAS* Object}
\usage{
\S4method{$}{LAS}(x, name)

\S4method{[[}{LAS,ANY,missing}(x, i, j, ...)

\S4method{$}{LAS}(x, name) <- value

\S4method{[[}{LAS,ANY,missing}(x, i, j) <- value

\S4method{[}{LAS,numeric,ANY}(x, i)

\S4method{[}{LAS,logical,ANY}(x, i)

\S4method{[}{LAS,logical,ANY}(x, i)

\S4method{[}{LAS,sf,ANY}(x, i)

\S4method{[}{LAS,sfc,ANY}(x, i)

\S4method{$}{LAScatalog}(x, name)

\S4method{[[}{LAScatalog,ANY,missing}(x, i, j, ...)

\S4method{[}{LAScatalog,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{LAScatalog,logical,ANY}(x, i)

\S4method{[}{LAScatalog,sf,ANY}(x, i)

\S4method{[}{LAScatalog,sfc,ANY}(x, i)

\S4method{[[}{LAScatalog,ANY,ANY}(x, i, j) <- value

\S4method{$}{LAScatalog}(x, name) <- value

\S4method{$}{LASheader}(x, name)

\S4method{$}{LASheader}(x, name) <- value

\S4method{[[}{LASheader,ANY,missing}(x, i, j, ...)

\S4method{[[}{LASheader,character,missing}(x, i) <- value
}
\arguments{
\item{x}{A \code{LAS*} object}

\item{name}{A literal character string or a name (possibly backtick quoted).}

\item{i}{string, name of elements to extract or replace.}

\item{j}{Unused.}

\item{...}{Unused}

\item{value}{typically an array-like R object of a similar class as x.}

\item{drop}{Unused}
}
\description{
Operators acting on \code{LAS*} objects. However, some have modified behaviors to prevent some
irrelevant modifications. Indeed, a \code{LAS*} object cannot contain anything, as the content
is restricted by the LAS specifications. If a user attempts to use one of these functions
inappropriately an informative error will be thrown.
}
\examples{
LASfile <- system.file("extdata", "example.laz", package="rlas")
las = readLAS(LASfile)

las$Intensity
las[["Z"]]
las[["Number of points by return"]]

\dontrun{
las$Z = 2L
las[["Z"]] = 1:10
las$NewCol = 0
las[["NewCol"]] = 0
}
}
