% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-itd.R
\name{lmfauto}
\alias{lmfauto}
\title{Individual Tree Detection Algorithm}
\usage{
lmfauto(plot = FALSE, hmin = 2)
}
\arguments{
\item{plot}{logical set it to \code{TRUE} if processing a plot instead of a large area. What changes
is the estimation of the local number of trees. It should be based on the local neighborhood for the general
case but this does not make sense for a plot.}

\item{hmin}{numeric. Minimum height of a tree. Threshold below which a point cannot be a local
maxima. Default is 2.}
}
\description{
This function is made to be used in \link{tree_detection}. It implements a fast and parameter-free
algorithm for individual tree detection with wide coverage. It is based on two local maximum filters
(LMF). The first pass performs a very rough estimation of the number of trees with a fixed window
size. Based on this rough estimate it automatically computes a variable windows size LMF with workable
parameters. This algorithm is made to process wide areas rather than small plots. See references
for more details.
}
\examples{
\dontrun{
#' LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile)
ttops <- tree_detection(las, lmfauto())
}
}
\references{
Roussel Jean-Romain, Development of a parameter-free algorithm for automatic tree
detection on wide territories (in prep.)
}
