% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumContrast.R
\name{g.diff.single}
\alias{g.diff.single}
\title{g.diff.single function}
\usage{
g.diff.single(ps, ghat, useq, model, transform, power, ...)
}
\arguments{
\item{ps}{A numeric vector of length 2 giving the values of phi and sigma^2, in that order.}

\item{ghat}{A numeric vector giving the nonparametric estimate of the PCF at all distances specified in useq (see below)}

\item{useq}{An increasing, equally spaced numeric vector giving the spatial distances at which the contrast criterion is to be evaluated.}

\item{model}{A character string specifying the form of the theoretical spatial correlation function (matches 'model' argument for CovarianceFct in the RandomFields packages).}

\item{transform}{A scalar-valued function which performs a numerical transformation of its argument. Used for calibration of the contrast criterion, by transforming both parametric and nonparametric forms of the PCF.}

\item{power}{A scalar used for calibration of the contrast criterion: the power which to raise the parametric and nonparametric forms of the PCF to.}

\item{...}{Additional arguments if required for definition of the correlation function as per 'model'. See ?CovarianceFct (RandomFields).}
}
\value{
A single numeric value providing the minimum contrast value for the specified value of the ps argument.
}
\description{
A function to find the minimum contrast (squared discrepancy) value based on the pair correlation function, for one specific value of phi
(spatial scale) and one specific value of sigma^2 (spatial variance) for the LGCP.
}
