\name{lgcpSimSpatial}
\alias{lgcpSimSpatial}
\title{lgcpSimSpatial function}
\usage{
  lgcpSimSpatial(owin = NULL, spatial.intensity = NULL,
    expectednumcases = 100, cellwidth = 0.05,
    model.parameters = lgcppars(sigma = 2, phi = 0.2),
    spatial.covmodel = "exponential", covpars = c(),
    ext = 2, plot = FALSE, inclusion = "touching")
}
\arguments{
  \item{owin}{observation window}

  \item{spatial.intensity}{an object that can be coerced to
  one of class spatialAtRisk}

  \item{expectednumcases}{the expected number of cases}

  \item{cellwidth}{width of cells in same units as
  observation window}

  \item{model.parameters}{parameters of model, see
  ?lgcppars. Only set sigma and phi for spatial model.}

  \item{spatial.covmodel}{spatial covariance function,
  default is exponential, see ?CovarianceFct}

  \item{covpars}{vector of additional parameters for
  spatial covariance function, in order they appear in
  chosen model in ?CovarianceFct}

  \item{ext}{how much to extend the parameter space by.
  Default is 2.}

  \item{plot}{logical, whether to plot the latent field.}

  \item{inclusion}{criterion for cells being included into
  observation window. Either 'touching' or 'centroid'. The
  former includes all cells that touch the observation
  window, the latter includes all cells whose centroids are
  inside the observation window.}
}
\value{
  a ppp object containing the data
}
\description{
  A function to simulate from a log gaussian process
}

