% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helping_functions.R
\name{dmvnorm_wrapper}
\alias{dmvnorm_wrapper}
\title{Wrapper for \code{dmvnorm}}
\usage{
dmvnorm_wrapper(eval_points, mu_1 = rep(0, nrow(eval_points)), mu_2 = rep(0,
  nrow(eval_points)), sig_1 = rep(1, nrow(eval_points)), sig_2 = rep(1,
  nrow(eval_points)), rho = rep(0, nrow(eval_points)), run_checks = TRUE)
}
\arguments{
\item{eval_points}{A \code{kx2} matrix with evaluation points}

\item{mu_1}{The first expectation vector}

\item{mu_2}{The second expectation vector}

\item{sig_1}{The first standard deviation vector}

\item{sig_2}{The second standard deviation vector}

\item{rho}{The correlation vector}

\item{run_checks}{Run sanity check for the arguments}
}
\description{
\code{dmvnorm_wrapper} is a function that evaluates the bivariate normal
distribution in a matrix of evaluation points, with local parameters.
}
\details{
This functions takes as arguments a matrix of grid points, and vectors of
parameter values, and returns the bivariate normal density at these points,
with these parameter values.
}
