% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lets_presab_grid.R
\name{lets.presab.grid}
\alias{lets.presab.grid}
\title{Create a presence-absence matrix of species' geographic ranges
within a user's grid shapefile (beta version)}
\usage{
lets.presab.grid(shapes, grid, sample.unit, remove.sp = TRUE,
  presence = NULL, origin = NULL, seasonal = NULL)
}
\arguments{
\item{shapes}{Object of class \code{SpatialPolygonsDataFrame} (see function \code{\link{readShapePoly}}
to open these files) containing the distribution of one or more species.
Species names should be in a column (within the .DBF table of the shapefile)
called BINOMIAL/binomial or SCINAME/sciname.}

\item{grid}{Object of class shapefile representing the spatial grid (e.g. regular/irregular cells,
political divisions, hexagonal grids, etc).
The grid and the shapefiles must be in the same projection.}

\item{sample.unit}{Object of class \code{character} with the name of the column (in the grid)
representing the sample units of the presence absence matrix.}

\item{remove.sp}{Logical, if \code{TRUE} the final matrix will not contain species that
do not match any cell in the grid.}

\item{presence}{A vector with the code numbers for the presence type to be considered in the process
(for IUCN spatial data \url{http://www.iucnredlist.org/technical-documents/spatial-data}, see metadata).}

\item{origin}{A vector with the code numbers for the origin type to be considered in the process
(for IUCN spatial data).}

\item{seasonal}{A vector with the code numbers for the seasonal type to be considered in the process
(for IUCN spatial data).}
}
\value{
The result is a \code{list} containing two objects:

 (I) A matrix the species presence (1) and absence (0) values per sample unity.

 (II) The original grid.
}
\description{
Convert species' ranges (in shapefile format) into a presence-absence matrix based on a grid in shapefile format.
}
\details{
This function is an alternative way to create a presence absence matrix when users
already have their own grid.
}
\examples{
\dontrun{
# Grid
sp.r <- rasterToPolygons(raster(resol = 5))
slot(sp.r, "data") <- cbind("ID" = 1:length(sp.r),
                            slot(sp.r, "data"))

# Species polygons
data(Phyllomedusa)
projection(Phyllomedusa) <- projection(sp.r)

# PAM
resu <- lets.presab.grid(Phyllomedusa, sp.r, "ID")

# Plot
rich_plus1 <- rowSums(resu$PAM) + 1
colfunc <- colorRampPalette(c("#fff5f0", "#fb6a4a", "#67000d"))
colors <- c("white", colfunc(max(rich_plus1)))
plot(resu$grid, border = "gray40",
     col = colors[rich_plus1])
map(add = TRUE)
}
}
\author{
Bruno Vilela & Fabricio Villalobos
}
\seealso{
\code{\link{plot.PresenceAbsence}}

\code{\link{lets.presab.birds}}

\code{\link{lets.shFilter}}
}

