% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lets_maplizer.R
\name{lets.maplizer}
\alias{lets.maplizer}
\title{Create a matrix summarizing species' attributes within cells of a PresenceAbsence object}
\usage{
lets.maplizer(x, y, z, func=mean, ras=FALSE)
}
\arguments{
\item{x}{A PresenceAbsence object.}

\item{y}{Species attribute to be considered.}

\item{z}{Species names in the same order as the attributes.}

\item{func}{function to summarize the species' atribute.}

\item{ras}{If \code{TRUE} the raster object will be returned together with the matrix}
}
\value{
Returns a matrix with the cells' geographic coordinates and the summarized species' attributes within them.
}
\description{
Summarize species atributes per cell in a presence-absence matrix.
}
\examples{
\dontrun{
data(PAM)
trait <- runif(32)
resu <- lets.maplizer(PAM, trait, PAM$S, ras=TRUE)
head(resu$Matrix)
plot(resu$raster) ; map(add=T)
}
}
\author{
Bruno Vilela
}
\seealso{
\code{\link{lets.presab}}

\code{\link{lets.presab.birds}}
}

