#'R functions for handling and analyzing macroecological data data, mainly species' geographic distributions (in ESRI shapefile format or point occurrences) and environmental variables (in raster format), as well as species' information related to their description (e.g. taxonomy and year of description) and conservation status (e.g. category of threat, population trend) as provided by the IUCN's RedList online database. The package includes functions to create presence-absence matrices based on species distributions and user-defined grid systems, from which several other functions could be applied to generate, for example, species richness rasters, geographical midpoints of species, and species- and site-based attributes. In addition, the package provides a function to create spatial correlograms of variables based on the Moran's I index, under the equiprobable or equidistant criterion to define distance classes.
#'The letsR package is in continuous development and suggestions are more than welcome!
#'We hope you enjoy it and find it useful.
#'
#' @name letsR
#' @aliases letsR-package
#' @docType package
#' @title Tools for Data Handling and Analysis in  Macroecology.
#' 
#' @author Bruno Vilela \email{brunovilelasilva@@hotmal.com}
#' @author Fabricio Villalobos \email{fabricio.villalobos@@gmail.com} 
#' 
#' @keywords package
#'
#' @details \tabular{ll}{
#' Package: \tab lestR\cr
#' Type: \tab Package\cr
#' Version: \tab 2.0\cr
#' Date: \tab 2015-02-09\cr
#' License: \tab GPL-2\cr
#' }
#' 
#' @import raster geosphere XML maptools maps sp rgdal fields
