library("leiden")
library("reticulate")
library("igraph")
library("bipartite")

context("running Leiden on a bipartite igraph object")

suppressWarnings(suppressMessages({
#imported from networkdata::southernwomen
bipartite_graph <- structure(list(32, FALSE,
                                  c(18, 19, 20, 21, 22, 23, 25, 26, 18,
                                    19, 20, 22, 23, 24, 25, 19, 20, 21, 22, 23, 24, 25, 26, 18, 20,
                                    21, 22, 23, 24, 25, 20, 21, 22, 24, 20, 22, 23, 25, 22, 23, 24,
                                    25, 23, 25, 26, 22, 24, 25, 26, 24, 25, 26, 29, 25, 26, 27, 29,
                                    25, 26, 27, 29, 30, 31, 24, 25, 26, 27, 29, 30, 31, 23, 24, 26,
                                    27, 28, 29, 30, 31, 24, 25, 27, 28, 29, 30, 31, 25, 26, 27, 29,
                                    26, 28, 26, 28),
                                  c(0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
                                    1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5,
                                    5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10,
                                    10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 13,
                                    13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 15, 15,
                                    15, 15, 16, 16, 17, 17),
                                  c(0, 8, 23, 1, 9, 15, 2, 10, 16, 24,
                                    30, 34, 3, 17, 25, 31, 4, 11, 18, 26, 32, 35, 38, 45, 5, 12,
                                    19, 27, 36, 39, 42, 70, 13, 20, 28, 33, 40, 46, 49, 63, 71, 78,
                                    6, 14, 21, 29, 37, 41, 43, 47, 50, 53, 57, 64, 79, 85, 7, 22,
                                    44, 48, 51, 54, 58, 65, 72, 86, 89, 91, 55, 59, 66, 73, 80, 87,
                                    74, 81, 90, 92, 52, 56, 60, 67, 75, 82, 88, 61, 68, 76, 83, 62,
                                    69, 77, 84),
                                  c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
                                    14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
                                    30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
                                    46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
                                    62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
                                    78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92),
                                  c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                    3, 6, 12, 16, 24, 32, 42, 56, 68, 74, 78, 85, 89, 93),
                                  c(0, 8, 15, 23, 30, 34, 38, 42, 45, 49, 53, 57, 63, 70, 78, 85,
                                    89, 91, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
                                    93, 93),
                                  list(c(1, 0, 1), structure(list(), .Names = character(0)),
                                       list(type = c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
                                                     FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
                                                     FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, TRUE,
                                                     TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE),
                                            name = c("EVELYN", "LAURA", "THERESA", "BRENDA",
                                                     "CHARLOTTE", "FRANCES", "ELEANOR", "PEARL", "RUTH",
                                                     "VERNE", "MYRA", "KATHERINE", "SYLVIA", "NORA", "HELEN",
                                                     "DOROTHY", "OLIVIA", "FLORA", "E1", "E2", "E3", "E4",
                                                     "E5", "E6", "E7", "E8", "E9", "E10", "E11", "E12",
                                                     "E13", "E14")), list())), class = "igraph")
bipartite_graph <- upgrade_graph(bipartite_graph)
}))
bipartite_adj_mat <- igraph::as_adjacency_matrix(bipartite_graph)


modules <- reticulate::py_module_available("leidenalg") && reticulate::py_module_available("igraph")

skip_if_no_python <- function() {
  if (!modules)
    testthat::skip("leidenalg not available for testing")
}


test_that("run with CPMVertexPartition.Bipartite", {
  skip_if_no_python()
  partition <- leiden(bipartite_graph,
                      partition_type = "CPMVertexPartition.Bipartite",
                      resolution_parameter = 0.1,
                      seed = 9001)
  expect_length(partition, length(V(bipartite_graph)))
  expect_equal(sort(unique(partition)), c(1, 2))
  expect_equal(partition,
               c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1,
                 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1))
  bipartite_graph
})

test_that("run with CPMVertexPartition.Bipartite and degree as node size", {
  skip_if_no_python()
  partition <- leiden(bipartite_graph,
                      partition_type = "CPMVertexPartition.Bipartite",
                      resolution_parameter = 0.01,
                      degree_as_node_size = TRUE,
                      seed = 9001)
  expect_length(partition, length(V(bipartite_graph)))
  expect_equal(sort(unique(partition)), c(1, 2))
  expect_equal(partition,
               c(1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2))
})

test_that("run with ModularityVertexPartition.Bipartite", {
  skip_if_no_python()
  partition <- leiden(bipartite_graph,
                      partition_type = "ModularityVertexPartition.Bipartite",
                      resolution_parameter = 0.01,
                      seed = 9001)
  expect_length(partition, length(V(bipartite_graph)))
  expect_equal(sort(unique(partition)), c(1, 2))
  expect_equal(partition,
               c(1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2))
})

