% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-.R
\name{key_standard}
\alias{key_standard}
\alias{key_auto}
\alias{key_manual}
\alias{key_map}
\alias{key_minor}
\alias{key_log}
\alias{key_none}
\title{Standard keys}
\usage{
key_auto(...)

key_manual(
  aesthetic,
  value = aesthetic,
  label = as.character(value),
  type = NULL,
  ...
)

key_map(data, ..., .call = caller_env())

key_minor(...)

key_log(
  prescale_base = NULL,
  negative_small = 0.1,
  expanded = TRUE,
  labeller = NULL,
  ...
)

key_none()
}
\arguments{
\item{...}{\code{\link[rlang:topic-data-mask]{<data-masking>}} A set of mappings
similar to those provided to \code{\link[ggplot2:aes]{aes()}}, which will be
evaluated in the \code{data} argument. These must contain \code{aesthetic} mapping.}

\item{aesthetic, value}{A vector of values for the guide to represent
equivalent to the \code{breaks} argument in scales. The \code{aesthetic} will be
mapped, whereas \code{value} will not. For most intents and purposes,
\code{aesthetic} and \code{value} should be identical.}

\item{label}{A \verb{<character>} or list of expressions to use as labels.}

\item{type}{A \verb{<character>} vector representing the one of the break types:
\code{"major"}, \code{"minor"} or \code{"mini"}. If \code{NULL} (default), all breaks are
treated as major breaks.}

\item{data}{A \verb{<data.frame>} or similar object coerced by
\code{\link[ggplot2:fortify]{fortify()}} to a \verb{<data.frame>}, in which the \code{mapping}
argument is evaluated.}

\item{.call}{A \link[rlang:topic-error-call]{call} to display in messages.}

\item{prescale_base}{A \verb{<numeric[1]>} giving the base of logarithm to
transform data manually. The default, \code{NULL}, will use the scale
transformation to calculate positions. It is only advisable to set the
\code{prescale_base} argument when the data have already been log-transformed.
When using a log-transform in the scale or in
\code{\link[ggplot2:coord_trans]{coord_trans()}}, the default \code{NULL} is recommended.}

\item{negative_small}{A \verb{<numeric[1]>} setting the smallest absolute value
that is marked with a tick in case the scale limits include 0 or negative
numbers.}

\item{expanded}{A \verb{<logical[1]>} determining whether the ticks should cover
the entire range after scale expansion (\code{TRUE}, default), or be restricted
to the scale limits (\code{FALSE}).}

\item{labeller}{A \verb{<function>} that receives major breaks and returns
formatted labels. For \code{key_log()}, \code{NULL} will default to
\code{\link[scales:label_log]{scales::label_log()}} for strictly positive numbers and a custom labeller
when negative numbers are included.}
}
\value{
For \code{key_auto()}, \code{key_minor()} and \code{key_log()} a function. For
\code{key_manual()} and \code{key_map()} a \verb{<data.frame>} with the \verb{<key_standard>}
class.
}
\description{
These functions are helper functions for working with tick marks as keys
in guides. They all share the goal of creating a guide key, but have
different outcomes:
\itemize{
\item \code{key_auto()} is a function factory whose functions extract a typical
key from major breaks in a scale.
\item \code{key_manual()} uses user-provided vectors to make a key.
\item \code{key_map()} makes mappings from a \verb{<data.frame>} to make a key.
\item \code{key_minor()} is a function factory whose functions also extract minor
break positions for minor tick marks.
\item \code{key_log()} is a function factory whose functions place ticks at intervals
in log10 space.
\item \code{key_none()} makes an empty key with no entries.
}
}
\examples{
# An example scale
template <- scale_x_continuous(limits = c(0, 10))

# The auto, minor and log keys operate on scales
key_auto()(template)
key_minor()(template)

# So does the log key
template <- scale_x_continuous(transform = "log10", limits = c(0.1, 10))
key_log()(template)

# Providing custom values
key_manual(
  aesthetic = 1:5,
  label = c("one", "two", "three", "four", "five")
)

# Values from a `<data.frame>`
key_map(ToothGrowth, aesthetic = unique(supp))

# Empty key
key_none()
}
\seealso{
Other keys: 
\code{\link{key_group}},
\code{\link{key_range}},
\code{\link{key_specialty}}
}
\concept{keys}
