% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{plot.lefkoProj}
\alias{plot.lefkoProj}
\title{Plot Projection Simulations}
\usage{
\method{plot}{lefkoProj}(
  x,
  variable = "popsize",
  style = "time",
  repl = "all",
  patch = "pop",
  auto_ylim = TRUE,
  auto_col = TRUE,
  auto_lty = TRUE,
  auto_title = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{lefkoProj} object.}

\item{variable}{The focus variable of the plot to produce. Defaults to
\code{"popsize"}, which produces line plots of the \code{popsize} element in
object \code{x}.}

\item{style}{A string denoting ther kind of plot to produce. Currently
limited to \code{"timeseries"}, which shows \code{variable} against time on
the x axis. Other choices include \code{"statespace"}, which plots
\code{variable} at one time on the x axis against the same variable in the
next time on the y axis.}

\item{repl}{The replicate to plot. Defaults to \code{"all"}, in which case
all replicates are plotted.}

\item{patch}{The patch to plot, as labeled in the \code{labels} element in
object \code{x}. Defaults to \code{"pop"}, in which case only the final
population-level projection is plotted. Can also be set to \code{"all"}, in
which case projections for all patches and population in the \code{labels}
element are plotted.}

\item{auto_ylim}{A logical value indicating whether the maximum of the y axis
should be determined automatically. Defaults to \code{TRUE}, but reverts to
\code{FALSE} if any setting for \code{ylim} is given.}

\item{auto_col}{A logical value indicating whether to shift the color of
lines associated with each patch automatically. Defaults to \code{TRUE}, but
reverts to \code{FALSE} if any setting for \code{col} is given.}

\item{auto_lty}{A logical value indicating whether to shift the line type
associated with each replicate automatically. Defaults to \code{TRUE}, but
reverts to \code{FALSE} if any setting for \code{lty} is given.}

\item{auto_title}{A logical value indicating whether to add a title to each
plot. The plot is composed of the concatenated population and patch names.
Defaults to \code{FALSE}.}

\item{...}{Other parameters used by functions \code{plot.default()} and
\code{lines()}.}
}
\value{
A plot of the results of a \code{\link{projection3}()} run.
}
\description{
Function \code{plot.lefkoProj()} produces plots of \code{lefkoProj} objects.
Acts as a convenient wrapper for the \code{plot.default()} function.
}
\section{Notes}{

Output plots are currently limited to time series and state space plots of
population size.

The default settings will preferentially plot any projections marked as
\code{0} in the \code{patch} portion of the \code{labels} element of the
input MPM. This can produce confusing results if a mean MPM resulting from
the \code{lmean()} function is used as input and the \code{add_mean} setting
is set to the default, which is \code{TRUE}.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep"),
  stage1 = c("Sd", "rep", "Sd", "rep", "all", "all"), 
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054),
  type = c(1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  repmatrix = lathrepm, supplement = lathsupp3, yearcol = "year2",
  indivcol = "individ")

lathproj <- projection3(ehrlen3, nreps = 5, stochastic = TRUE)
plot(lathproj)

}
