% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{verticalize3}
\alias{verticalize3}
\title{Create Historical Vertical Data Frame From Horizontal Data Frame}
\usage{
verticalize3(
  data,
  noyears,
  firstyear,
  popidcol = 0,
  patchidcol = 0,
  individcol = 0,
  blocksize,
  xcol = 0,
  ycol = 0,
  juvcol = 0,
  sizeacol,
  sizebcol = 0,
  sizeccol = 0,
  repstracol = 0,
  repstrbcol = 0,
  fecacol = 0,
  fecbcol = 0,
  indcovacol = 0,
  indcovbcol = 0,
  indcovccol = 0,
  aliveacol = 0,
  deadacol = 0,
  obsacol = 0,
  nonobsacol = 0,
  censorcol = 0,
  repstrrel = 1,
  fecrel = 1,
  stagecol = 0,
  stageassign = NA,
  stagesize = NA,
  censorkeep = 0,
  censorRepeat = TRUE,
  censor = FALSE,
  spacing = NA,
  NAas0 = FALSE,
  NRasRep = FALSE,
  reduce = TRUE,
  a2check = FALSE
)
}
\arguments{
\item{data}{The horizontal data file.}

\item{noyears}{The number of years or observation periods in the dataset.}

\item{firstyear}{The first year or time of observation.}

\item{popidcol}{A variable name or column number corresponding to the 
identity of the population for each individual.}

\item{patchidcol}{A variable name or column number corresponding to the 
identity of the patch for each individual, if patches have been designated 
within populations.}

\item{individcol}{A variable name or column number corresponding to the 
identity of each individual.}

\item{blocksize}{The number of variables corresponding to each time in the
input dataset designated in \code{data}.}

\item{xcol}{A variable name or column number corresponding to the x 
coordinate of each individual in Cartesian space.}

\item{ycol}{A variable name or column number corresponding to the y
coordinate of each individual in Cartesian space.}

\item{juvcol}{A variable name or column number that marks individuals in
immature stages within the dataset. The \code{verticalize3()} function 
assumes that immature individuals are identified in this variable marked with
a number equal to or greater than 1, and that mature individuals are marked
as 0 or NA.}

\item{sizeacol}{A variable name or column number corresponding to the
size entry associated with the first year or observation time in the dataset.}

\item{sizebcol}{A second variable name or column number corresponding to the
size entry associated with the first year or observation time in the dataset.}

\item{sizeccol}{A third variable name or column number corresponding to the
size entry associated with the first year or observation time in the dataset.}

\item{repstracol}{A variable name or column number corresponding to the
production of reproductive structures, such as flowers, associated with the 
first year or observation period in the input dataset. This can be binomial 
or count data, and is used to in analysis of the probability of reproduction.}

\item{repstrbcol}{A second variable name or column number corresponding to
the production of reproductive structures, such as flowers, associated with
the first year or observation period in the input dataset. This can be 
binomial or count data, and is used to in analysis of the probability of
reproduction.}

\item{fecacol}{A variable name or column number denoting fecundity associated
with the first year or observation time in the input dataset. This may 
represent egg counts, fruit counts, seed production, etc.}

\item{fecbcol}{A second variable name or column number denoting fecundity
associated with the first year or observation time in the input dataset. This 
may represent egg counts, fruit counts, seed production, etc.}

\item{indcovacol}{A variable name or column number corresponding to an
individual covariate to be used in analysis.}

\item{indcovbcol}{A variable name or column number corresponding to an
individual covariate to be used in analysis.}

\item{indcovccol}{A second variable name or column number corresponding to an
individual covariate to be used in analysis.}

\item{aliveacol}{A variable name or column number that provides information
on whether an individual is alive at a given time. If used, living status
must be designated as binomial (living = 1, dead = 0).}

\item{deadacol}{A variable name or column number that provides information on
whether an individual is alive at a given time. If used, dead status must be
designated as binomial (dead = 1, living = 0).}

\item{obsacol}{A variable name or column number providing information on 
whether an individual is in an observable stage at a given time. If used, 
observation status must be designated as binomial (observed = 1, not 
observed = 0).}

\item{nonobsacol}{A variable name or column number providing information on
whether an individual is in an unobservable stage at a given time. If used,
observation status must be designated as binomial (not observed = 1, 
observed = 0).}

\item{censorcol}{A variable name or column number corresponding to the first
entry of a censor variable, used to distinguish between entries to use and
entries not to use, or to designate entries with special issues that require
further attention. If used, this should be associated with the first year or
observation time, and all other years or times must also have censor columns.}

\item{repstrrel}{This is a scalar multiplier on variable \code{repstrbcol} to
make it equivalent to \code{repstracol}. This can be useful if two 
reproductive status variables have related but unequal units, for example if
\code{repstracol} refers to one-flowered stems while \code{repstrbcol} refers
to two-flowered stems. Defaults to 1.}

\item{fecrel}{This is a scalar multiplier on variable \code{fecbcol} to make
it equivalent to \code{fecacol}. This can be useful if two fecundity 
variables have related but unequal units. Defaults to 1.}

\item{stagecol}{Optional variable name or column number corresponding to life
history stage at a given time.}

\item{stageassign}{The stageframe object identifying the life history model
being operationalized. Note that if \code{stagecol} is provided, then this
stageframe is not used for stage designation.}

\item{stagesize}{A variable name or column number describing which size 
variable to use in stage estimation. Defaults to NA, and can also take 
\code{sizea}, \code{sizeb}, \code{sizec}, or \code{sizeadded}, depending on
which size variable is chosen.}

\item{censorkeep}{The value of the censor variable identifying data to be
included in analysis. Defaults to 0, but may take any value including NA.
Note that if NA is the value to keep, then this function will alter all NAs
to 0 values, and all other values to 1, treating 0 as the value to keep.}

\item{censorRepeat}{A logical value indicating whether the censor variable
is a single column, or whether it repeats across time blocks. Defaults to
TRUE.}

\item{censor}{A logical variable determining whether the output data should 
be censored using the variable defined in \code{censorcol}. Defaults to 
FALSE.}

\item{spacing}{The spacing at which density should be estimated, if density
estimation is desired and x and y coordinates are supplied. Given in the same
units as those used in the x and y coordinates given in \code{xcol} and 
\code{ycol}. Defaults to NA.}

\item{NAas0}{If TRUE, then all NA entries for size and fecundity variables 
will be set to 0. This can help increase the sample size analyzed by 
\code{\link{modelsearch}()}, but should only be used when it is clear that 
this substitution is biologically realistic. Defaults to FALSE.}

\item{NRasRep}{If TRUE, then will treat non-reproductive but mature 
individuals as reproductive during stage assignment. This can be useful when
a matrix is desired without separation of reproductive and non-reproductive
but mature stages of the same size. Only used if \code{stageassign} is set
to a stageframe. Defaults to FALSE.}

\item{reduce}{A logical variable determining whether unused variables and 
some invariant state variables should be removed from the output dataset.
Defaults to TRUE.}

\item{a2check}{A logical variable indicating whether to retain all data with
living status at time \emph{t} equal to 0. Defaults to FALSE, and should be
kept on FALSE except to inspect potential errors in the dataset.}
}
\value{
If all inputs are properly formatted, then this function will output
a historical vertical data frame (class \code{hfvdata}), meaning that the
output data frame will have three consecutive times of size and reproductive
data per individual per row. This data frame is in standard format for all
functions used in \code{lefko3}, and so can be used without further
modification.

Variables in this data frame include the following:
\item{rowid}{Unique identifier for the row of the data frame.}
\item{popid}{Unique identifier for the population, if given.}
\item{patchid}{Unique identifier for patch within population, if given.}
\item{individ}{Unique identifier for the individual.}
\item{year2}{Year or time at time \emph{t}.}
\item{firstseen}{Year or time of first observation.}
\item{lastseen}{Year or time of last observation.}
\item{obsage}{Observed age in time \emph{t}, assuming first observation
corresponds to age = 0.}
\item{obslifespan}{Observed lifespan, given as \code{lastseen - firstseen + 1}.}
\item{xpos1,xpos2,xpos3}{X position in Cartesian space in times \emph{t}-1,
\emph{t}, and \emph{t}+1, respectively, if provided.}
\item{ypos1,ypos2,ypos3}{Y position in Cartesian space in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively, if provided.}
\item{sizea1,sizea2,sizea3}{Main size measurement in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{sizeb1,sizeb2,sizeb3}{Secondary size measurement in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{sizec1,sizec2,sizec3}{Tertiary measurement in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{size1added,size2added,size3added}{Sum of primary, secondary, and 
tertiary size measurements in times \emph{t}-1, \emph{t}, and \emph{t}+1, 
respectively.}
\item{repstra1,repstra2,repstra3}{Main numbers of reproductive structures in
times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstrb1,repstrb2,repstrb3}{Secondary numbers of reproductive 
structures in times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstr1added,repstr2added,repstr3added}{Sum of primary and secondary
reproductive structures in times \emph{t}-1, \emph{t}, and \emph{t}+1, 
respectively.}
\item{feca1,feca2,feca3}{Main numbers of offspring in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{fecb1,fecb2, fecb3}{Secondary numbers of offspring in times \emph{t}-1,
\emph{t}, and \emph{t}+1, respectively.}
\item{fec1added,fec2added,fec3added}{Sum of primary and secondary fecundity
in times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{censor1,censor2,censor3}{Censor state values in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{juvgiven1,juvgiven2,juvgiven3}{Binomial variable indicating whether
individual is juvenile in times \emph{t}-1, \emph{t}, and \emph{t}+1. Only 
given if \code{juvcol} is provided.}
\item{obsstatus1,obsstatus2,obsstatus3}{Binomial observation state in times
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstatus1,repstatus2,repstatus3}{Binomial reproductive state in times 
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{fecstatus1,fecstatus2,fecstatus3}{Binomial offspring production state
in times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{matstatus1,matstatus2,matstatus3}{Binomial maturity state in times
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{alive1,alive2,alive3}{Binomial state as alive in times \emph{t}-1,
 \emph{t}, and \emph{t}+1, respectively.}
\item{density}{Density of individuals per unit designated in \code{spacing}.
Only given if spacing is not NA.}
}
\description{
\code{verticalize3()} returns a vertically formatted demographic data frame 
organized to create historical projection matrices, given a horizontally
formatted input data frame.
}
\section{Notes}{

In some datasets on species with unobserveable stages, observation status
(\code{obsstatus}) might not be inferred properly if a single size variable
is used that does not yield sizes greater than 0 in all cases in which
individuals were observed. Such situations may arise, for example, in plants
when leaf number is the dominant size variable used, but individuals
occasionally occur with inflorescences but no leaves. In this instances,
it helps to mark related variables as \code{sizeb} and \code{sizec}, because
observation status will be interpreted in relation to all 3 size variables.
Further analysis can then utilize only a single size variable, of the user's
choosing. Similar issues can arise in reproductive status (\code{repstatus}).

Warnings that some individuals occur in state combinations that do not match
any stages in the stageframe used to assign stages are common when first
working with a dataset. Typically, these situations can be identified as
\code{NoMatch} entries in \code{stage3}, although such entries may crop up in
\code{stage1} and \code{stage2}, as well. In rare cases, these warnings will
arise with no concurrent \code{NoMatch} entries, which indicates that the
input dataset contained conflicting state data at once suggesting that the
individual is in some stage but is also dead. The latter is removed if the
conflict occurs in time \emph{t} or time \emph{t}-1, as only living entries
are allowed in these times.

Care should be taken to avoid variables with negative values indicating size,
fecundity, or reproductive or observation status. Negative values can be
interpreted in different ways, typically reflecting estimation through other
algorithms rather than actual measured data. Variables holding negative
values can conflict with data management algorithms in ways that are
difficult to predict.
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "Sd", "rep", "rep"),
  stage1 = c("Sd", "rep", "rep", "all", "all"), 
  givenrate = c(0.345, 0.345, 0.054, NA, NA),
  multiplier = c(NA, NA, NA, 0.345, 0.054),
  type = c(1, 1, 1, 3, 3), stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]

# Cypripedium example
rm(list=ls(all=TRUE))

data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, 0.40, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")
                       
cyp2mean <- lmean(cypmatrix2r)
cyp2mean

}
