% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{projection3}
\alias{projection3}
\title{Estimate Stochastic Population Growth Rate}
\usage{
projection3(
  mpm,
  times = 10000L,
  stochastic = FALSE,
  standardize = FALSE,
  growthonly = TRUE,
  integeronly = FALSE,
  start_vec = NULL,
  tweights = NULL
)
}
\arguments{
\item{mpm}{A matrix projection model of class \code{lefkoMat}, or a list of
full matrix projection matrices.}

\item{times}{Number of iterations to random samples. Defaults to 10,000.}

\item{stochastic}{A logical value denoting whether to conduct a stochastic
projection or a deterministic / cyclical projection.}

\item{standardize}{A logical value denoting whether to re-standardize the
population size to 1.0 at each time step. Defaults to FALSE.}

\item{growthonly}{A logical value indicating whether to produce only the
projected population size at each time step, or a vector showing the stage
distribution followed by the reproductive value vector followed by the full
population size at each time step. Defaults to TRUE.}

\item{integeronly}{A logical value indicating whether to round the number of
individuals projected in each stage at each time step to the nearest
integer. Defaults to FALSE.}

\item{start_vec}{An optional numeric vector denoting the starting stage
distribution for the projection. Defaults to a single individual of each
stage.}

\item{tweights}{An optional numeric vector denoting the probabilistic
weightings of annual matrices. Defaults to equal weighting among times.}
}
\value{
A list with two elements:
\item{projection}{A list of matrices showing the total number of individuals
per stage per time step, or showing the former with the projected stage 
distribution and reproductive value per stage per time step followed by
the total population size per time step (all row-bound in order).}
\item{labels}{A data frame showing the order of populations and patches in
item \code{projection}.}

Projections are run both at the patch level and at the population level.
Population level estimates will be noted at the end of the
data frame with 0 entries for patch designation.
}
\description{
Function \code{projection3()} projects the population forward in time by
a user-defined number of time steps. Projections may be deterministic or
stochastic. If deterministic, then projections will be cyclical if mjultiple
years of matrices exist for each population or patch. If stochastic, then
annual matrices will be shuffled within patches and populations.
}
\section{Notes}{

Weightings given in \code{tweights} do not need to sum to 1. Final
weightings used will be based on the proportion per element of the sum of
elements in the user-supplied vector.
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"),
  stage2 = c("Sd", "Sd", "Sd"), stage1 = c("Sd", "rep", "rep"),
  givenrate = c(0.345, 0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  repmatrix = lathrepm, overwrite = lathover3, yearcol = "year2",
  indivcol = "individ")

lathproj <- projection3(ehrlen3, stochastic = TRUE)

# Cypripedium example
rm(list = ls(all=TRUE))
data(cypdata)
 
sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4, 
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE, 
  NRasRep = TRUE)

rep_cyp_raw <- matrix(0, 11, 11)
rep_cyp_raw[1:2,7:11] <- 0.5

cypover3r <- overwrite(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL", 
    "SL", "SL", "D", "XSm", "Sm", "D", "XSm", "Sm"), 
  stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", 
    "SL", "SL", "SL", "SL", "SL"),
  stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "SL", "P3", 
    "P3", "P3", "SL", "SL", "SL"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", 
    "XSm", "Sm"), 
  eststage2 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", 
    "XSm", "XSm", "XSm"), 
  eststage1 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", 
    "XSm", "XSm", "XSm"), 
  givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, 0.4, 0.4, NA, NA, NA, 
    NA, NA, NA), 
  type = c("S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", 
    "S", "S"))

cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added", "size1added"), 
  repmatrix = rep_cyp_raw, overwrite = cypover3r, yearcol = "year2", 
  patchcol = "patchid", indivcol = "individ")

cypstoch <- projection3(cypmatrix3r, stochastic = TRUE)

}
