% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{elasticity3.lefkoMat}
\alias{elasticity3.lefkoMat}
\title{Estimate Elasticity of Population Growth Rate of a lefkoMat Object}
\usage{
\method{elasticity3}{lefkoMat}(mats, stochastic = FALSE, steps = 10000, time_weights = NA, ...)
}
\arguments{
\item{mats}{An object of class \code{lefkoMat}.}

\item{stochastic}{A logical value determining whether to conduct a
deterministic (FALSE) or stochastic (TRUE) elasticity analysis. Defaults to
FALSE.}

\item{steps}{The number of times to project forward in stochastic simulation.
Defaults to 10,000.}

\item{time_weights}{Numeric vector denoting the probabilistic weightings of
annual matrices. Defaults to equal weighting among times.}

\item{...}{Other parameters.}
}
\value{
This function returns an object of class \code{lefkoElas}, which is a
list with 7 elements. The first, h_elasmats, is a list of historical
elasticity matrices (NULL if an ahMPM is used as input). The second,
ah_elasmats, is a list of either ahistorical elasticity matrices if an ahMPM
is used as input, or, if an hMPM is used as input, then the result is a list
of elasticity matrices in which historical elasticities have been summed by
the stage in times t and t+1 to produce historically-corrected elasticity
matrices, which are equivalent in dimension to ahistorical elasticity
matrices but reflect the effects of stage in time t-1. The third element,
h_stages, is a data frame showing historical stage pairs (NULL if ahMPM used
as input). The fourth element, ah_stages, is a data frame showing the order
of ahistorical stages. The last 3 elements are the A, U, and F portions of
the input.
}
\description{
\code{elasticity3.lefkoMat()} returns the elasticities of population growth
rate to elements of all \code{$A} matrices in an object of class
\code{lefkoMat}. If deterministic, then \eqn{\lambda} is taken as the
population growth rate. If stochastic, then stochastic \eqn{\lambda}, or
the stochastic growth rate, is taken as the population growth rate. This
function can handle large and sparse matrices, and so can be used with large
historical matrices, IPMs, age x stage matrices, as well as smaller
ahistorical matrices.
}
\section{Notes}{

Deterministic elasticities are estimated as eqn. 9.72 in Caswell (2001,
Matrix Population Models). Stochastic elasticities are estimated as eqn.
14.99 in Caswell (2001). Note that stochastic elasticities are of the
stochastic \eqn{\lambda}, while stochastic sensitivities are with regard to
the log of the stochastic \eqn{\lambda}.

Currently, this function does not estimate equivalent ahistorical stochastic
elasticities for input historical matrices.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"),
  stage2 = c("Sd", "Sd", "Sd"), stage1 = c("Sd", "rep", "rep"),
  givenrate = c(0.345, 0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  repmatrix = lathrepm, overwrite = lathover3, yearcol = "year2",
  indivcol = "individ")

elasticity3(ehrlen3, stochastic = TRUE)

}
\seealso{
\code{\link{elasticity3}()}

\code{\link{elasticity3.matrix}()}

\code{\link{elasticity3.list}()}

\code{\link{summary.lefkoElas}()}
}
