% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{tileOptions}
\alias{tileOptions}
\alias{WMSTileOptions}
\alias{popupOptions}
\alias{labelOptions}
\alias{markerOptions}
\alias{markerClusterOptions}
\alias{pathOptions}
\title{Extra options for map elements and layers}
\usage{
tileOptions(
  minZoom = 0,
  maxZoom = 18,
  maxNativeZoom = NULL,
  tileSize = 256,
  subdomains = "abc",
  errorTileUrl = "",
  tms = FALSE,
  noWrap = FALSE,
  zoomOffset = 0,
  zoomReverse = FALSE,
  opacity = 1,
  zIndex = 1,
  unloadInvisibleTiles = NULL,
  updateWhenIdle = NULL,
  detectRetina = FALSE,
  ...
)

WMSTileOptions(
  styles = "",
  format = "image/jpeg",
  transparent = FALSE,
  version = "1.1.1",
  crs = NULL,
  ...
)

popupOptions(
  maxWidth = 300,
  minWidth = 50,
  maxHeight = NULL,
  autoPan = TRUE,
  keepInView = FALSE,
  closeButton = TRUE,
  zoomAnimation = NULL,
  closeOnClick = NULL,
  className = "",
  ...
)

labelOptions(
  interactive = FALSE,
  clickable = NULL,
  noHide = NULL,
  permanent = FALSE,
  className = "",
  direction = "auto",
  offset = c(0, 0),
  opacity = 1,
  textsize = "10px",
  textOnly = FALSE,
  style = NULL,
  zoomAnimation = NULL,
  sticky = TRUE,
  ...
)

markerOptions(
  interactive = TRUE,
  clickable = NULL,
  draggable = FALSE,
  keyboard = TRUE,
  title = "",
  alt = "",
  zIndexOffset = 0,
  opacity = 1,
  riseOnHover = FALSE,
  riseOffset = 250,
  ...
)

markerClusterOptions(
  showCoverageOnHover = TRUE,
  zoomToBoundsOnClick = TRUE,
  spiderfyOnMaxZoom = TRUE,
  removeOutsideVisibleBounds = TRUE,
  spiderLegPolylineOptions = list(weight = 1.5, color = "#222", opacity = 0.5),
  freezeAtZoom = FALSE,
  ...
)

pathOptions(
  lineCap = NULL,
  lineJoin = NULL,
  clickable = NULL,
  interactive = TRUE,
  pointerEvents = NULL,
  className = "",
  ...
)
}
\arguments{
\item{minZoom, maxZoom, maxNativeZoom, tileSize, subdomains, errorTileUrl, tms, noWrap, zoomOffset, zoomReverse, zIndex, unloadInvisibleTiles, updateWhenIdle, detectRetina}{the tile layer options; see
\url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#tilelayer}}

\item{opacity}{Tooltip container opacity. Ranges from 0 to 1. Default value is \code{1} (different from leaflet.js \code{0.9}); see \url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#tooltip-opacity}}

\item{...}{extra options passed to underlying Javascript object constructor.}

\item{styles}{comma-separated list of WMS styles}

\item{format}{WMS image format (use \code{"image/png"} for layers with
transparency)}

\item{transparent}{if \code{TRUE}, the WMS service will return images with
transparency}

\item{version}{version of the WMS service to use}

\item{crs}{Coordinate Reference System to use for the WMS requests, defaults.}

\item{maxWidth, minWidth, maxHeight, autoPan, keepInView, closeButton, closeOnClick}{popup options; see \url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#popup-option}}

\item{zoomAnimation}{deprecated. See \url{https://github.com/Leaflet/Leaflet/blob/master/CHANGELOG.md#api-changes-5}}

\item{className}{a CSS class name set on an element}

\item{interactive}{whether the element emits mouse events}

\item{clickable}{DEPRECATED! Use the \code{interactive} option.}

\item{noHide, direction, offset, permanent}{label options; see \url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#tooltip-option}}

\item{textsize}{Change the text size of a single tooltip}

\item{textOnly}{Display only the text, no regular surrounding box.}

\item{style}{list of css style to be added to the tooltip}

\item{sticky}{If true, the tooltip will follow the mouse instead of being fixed at the feature center. Default value is \code{TRUE} (different from leaflet.js \code{FALSE}); see \url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#tooltip-sticky}}

\item{draggable, keyboard, title, alt, zIndexOffset, riseOnHover, riseOffset}{marker options; see \url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#marker-option}}

\item{showCoverageOnHover}{when you mouse over a cluster it shows the bounds
of its markers}

\item{zoomToBoundsOnClick}{when you click a cluster we zoom to its bounds}

\item{spiderfyOnMaxZoom}{when you click a cluster at the bottom zoom level we
spiderfy it so you can see all of its markers}

\item{removeOutsideVisibleBounds}{clusters and markers too far from the
viewport are removed from the map for performance}

\item{spiderLegPolylineOptions}{Allows you to specify PolylineOptions (\url{https://web.archive.org/web/20220702182250/https://leafletjs.com/reference-1.3.4.html#polyline-option}) to style spider legs. By default, they are { weight: 1.5, color: "#222", opacity: 0.5 }}

\item{freezeAtZoom}{Allows you to freeze cluster expansion to a zoom level.
Can be a zoom level e.g. 10, 12 or "max" or "maxKeepSpiderify"
See \url{https://github.com/ghybs/Leaflet.MarkerCluster.Freezable#api-reference}}

\item{lineCap}{a string that defines
\href{https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-linecap}{shape
 to be used at the end} of the stroke}

\item{lineJoin}{a string that defines
\href{https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-linejoin}{shape
 to be used at the corners} of the stroke}

\item{pointerEvents}{sets the \code{pointer-events} attribute on the path if
SVG backend is used}
}
\description{
The rest of all possible options for map elements and layers that are not
listed in the layer functions.
}
\section{Functions}{
\itemize{
\item \code{tileOptions()}: Options for tile layers

\item \code{WMSTileOptions()}: Options for WMS tile layers

\item \code{popupOptions()}: Options for popups

\item \code{labelOptions()}: Options for labels

\item \code{markerOptions()}: Options for markers

\item \code{markerClusterOptions()}: Options for marker clusters

\item \code{pathOptions()}: Options for vector layers (polylines, polygons,
rectangles, and circles, etc)

}}
\seealso{
\code{\link{leafletCRS}}
  to map CRS (don't change this if you're not sure what it means)
}
