% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{addSearchOSM}
\alias{addSearchOSM}
\alias{searchOSMText}
\alias{removeSearchOSM}
\alias{clearSearchOSM}
\alias{addReverseSearchOSM}
\alias{addSearchGoogle}
\alias{removeSearchGoogle}
\alias{addReverseSearchGoogle}
\alias{addSearchUSCensusBureau}
\alias{removeSearchUSCensusBureau}
\title{Add a OSM search control to the map.}
\usage{
addSearchOSM(map, options = searchOptions(autoCollapse = TRUE, minLength = 2))

searchOSMText(map, text = "")

removeSearchOSM(map)

clearSearchOSM(map)

addReverseSearchOSM(
  map,
  showSearchLocation = TRUE,
  showBounds = FALSE,
  showFeature = TRUE,
  fitBounds = TRUE,
  displayText = TRUE,
  group = NULL,
  marker = list(icon = NULL),
  showFeatureOptions = list(weight = 2, color = "red", dashArray = "5,10", fillOpacity =
    0.2, opacity = 0.5),
  showBoundsOptions = list(weight = 2, color = "#444444", dashArray = "5,10", fillOpacity
    = 0.2, opacity = 0.5),
  showHighlightOptions = list(opacity = 0.8, fillOpacity = 0.5, weight = 5)
)

addSearchGoogle(
  map,
  apikey = Sys.getenv("GOOGLE_MAP_GEOCODING_KEY"),
  options = searchOptions(autoCollapse = TRUE, minLength = 2)
)

removeSearchGoogle(map)

addReverseSearchGoogle(
  map,
  apikey = Sys.getenv("GOOGLE_MAP_GEOCODING_KEY"),
  showSearchLocation = TRUE,
  showBounds = FALSE,
  showFeature = TRUE,
  fitBounds = TRUE,
  displayText = TRUE,
  group = NULL
)

addSearchUSCensusBureau(
  map,
  options = searchOptions(autoCollapse = TRUE, minLength = 20)
)

removeSearchUSCensusBureau(map)
}
\arguments{
\item{map}{a map widget object}

\item{options}{Search Options}

\item{text}{The search text}

\item{showSearchLocation}{Boolean. If TRUE displays a Marker on the searched location's coordinates.}

\item{showBounds}{Boolean. If TRUE show the bounding box of the found feature.}

\item{showFeature}{Boolean. If TRUE show the found feature.
Depending upon the feature found this can be a marker, a line or a polygon.}

\item{fitBounds}{Boolean. If TRUE set maps bounds to queried and found location.
For this to be effective one of \code{showSearchLocation}, \code{showBounds}, \code{showFeature} shoule also be TRUE.}

\item{displayText}{Boolean. If TRUE show a text box with found location's name on the map.}

\item{group}{String. An optional group to hold all the searched locations and their results.}

\item{marker}{Let's you set the icon. Can be an icon made by \code{\link[leaflet]{makeIcon}} or \code{\link[leaflet]{makeAwesomeIcon}}}

\item{showFeatureOptions}{A list of styling options for the found feature}

\item{showBoundsOptions}{A list of styling options for the bounds of the found feature}

\item{showHighlightOptions}{A list of styling options for the hover effect of a found feature}

\item{apikey}{String. API Key for Google GeoCoding Service.}
}
\value{
modified map

modified map

modified map

modified map

modified map

modified map

modified map

modified map

modified map

modified map
}
\description{
Add a OSM search control to the map.

Add a OSM search control to the map.

Removes the OSM search control from the map.

Clears the search marker

Add a Google search control to the map.

Removes the Google search control from the map.

Add a US Census Bureau search control to the map.

Removes the US Census Bureau search control from the map.
}
\examples{
leaflet() \%>\%
  addProviderTiles(providers$Esri.WorldStreetMap) \%>\%
  addResetMapButton() \%>\%
  addSearchGoogle()

## for more examples see
# browseURL(system.file("examples/search.R", package = "leaflet.extras"))

}
