% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawOptions.R
\name{drawShapeOptions}
\alias{drawShapeOptions}
\alias{drawPolylineOptions}
\alias{drawPolygonOptions}
\alias{drawRectangleOptions}
\alias{drawCircleOptions}
\alias{drawMarkerOptions}
\alias{drawCircleMarkerOptions}
\alias{selectedPathOptions}
\alias{editToolbarOptions}
\title{Options for drawn shapes}
\usage{
drawShapeOptions(
  stroke = TRUE,
  color = "#03f",
  weight = 1,
  opacity = 1,
  fill = TRUE,
  fillColor = "#03f",
  fillOpacity = 0.4,
  dashArray = NULL,
  lineCap = NULL,
  lineJoin = NULL,
  clickable = TRUE,
  pointerEvents = NULL,
  smoothFactor = 1,
  noClip = TRUE
)

drawPolylineOptions(
  allowIntersection = TRUE,
  drawError = list(color = "#b00b00", timeout = 2500),
  guidelineDistance = 20,
  maxGuideLineLength = 4000,
  showLength = TRUE,
  metric = TRUE,
  feet = TRUE,
  nautic = FALSE,
  zIndexOffset = 2000,
  shapeOptions = drawShapeOptions(fill = FALSE),
  repeatMode = FALSE
)

drawPolygonOptions(
  showArea = FALSE,
  metric = TRUE,
  shapeOptions = drawShapeOptions(),
  repeatMode = FALSE
)

drawRectangleOptions(
  showArea = TRUE,
  metric = TRUE,
  shapeOptions = drawShapeOptions(),
  repeatMode = FALSE
)

drawCircleOptions(
  showRadius = TRUE,
  metric = TRUE,
  feet = TRUE,
  nautic = FALSE,
  shapeOptions = drawShapeOptions(),
  repeatMode = FALSE
)

drawMarkerOptions(markerIcon = NULL, zIndexOffset = 2000, repeatMode = FALSE)

drawCircleMarkerOptions(
  stroke = TRUE,
  color = "#3388ff",
  weight = 4,
  opacity = 0.5,
  fill = TRUE,
  fillColor = NULL,
  fillOpacity = 0.2,
  clickable = TRUE,
  zIndexOffset = 2000,
  repeatMode = FALSE
)

selectedPathOptions(
  dashArray = c("10, 10"),
  weight = 2,
  color = "black",
  fill = TRUE,
  fillColor = "black",
  fillOpacity = 0.6,
  maintainColor = FALSE
)

editToolbarOptions(
  edit = TRUE,
  remove = TRUE,
  selectedPathOptions = NULL,
  allowIntersection = TRUE
)
}
\arguments{
\item{stroke}{Whether to draw stroke along the path. Set it to false to disable borders on polygons or circles.}

\item{color}{Stroke color.}

\item{weight}{Stroke width in pixels.}

\item{opacity}{Stroke opacity.}

\item{fill}{Whether to fill the path with color. Set it to false to disable filling on polygons or circles.}

\item{fillColor}{same as color    Fill color.}

\item{fillOpacity}{Fill opacity.}

\item{dashArray}{A string that defines the stroke dash pattern. Doesn't work on canvas-powered layers (e.g. Android 2).}

\item{lineCap}{A string that defines shape to be used at the end of the stroke.}

\item{lineJoin}{A string that defines shape to be used at the corners of the stroke.}

\item{clickable}{If false, the vector will not emit mouse events and will act as a part of the underlying map.}

\item{pointerEvents}{Sets the pointer-events attribute on the path if SVG backend is used.}

\item{smoothFactor}{How much to simplify the polyline on each zoom level. More means better performance and smoother look, and less means more accurate representation.}

\item{noClip}{Disabled polyline clipping.}

\item{allowIntersection}{Determines if line segments can cross.}

\item{drawError}{Configuration options for the error that displays if an intersection is detected.}

\item{guidelineDistance}{Distance in pixels between each guide dash.}

\item{maxGuideLineLength}{Maximum length of the guide lines.}

\item{showLength}{Whether to display the distance in the tooltip.}

\item{metric}{Determines which measurement system (metric or imperial) is used.}

\item{feet}{When not metric, use feet instead of yards for display.}

\item{nautic}{When not metric, not feet, use nautic mile for display.}

\item{zIndexOffset}{This should be a high number to ensure that you can draw over all other layers on the map.}

\item{shapeOptions}{Leaflet Polyline options    See \code{\link{drawShapeOptions}}().}

\item{repeatMode}{Determines if the draw tool remains enabled after drawing a shape.}

\item{showArea}{Show the area of the drawn polygon in m², ha or km². The area is only approximate and become less accurate the larger the polygon is.}

\item{showRadius}{Show the radius of the drawn circle in m, km, ft (feet), or nm (nautical mile).}

\item{markerIcon}{Can be either \code{\link[leaflet]{makeIcon}}() OR \code{\link[leaflet]{makeAwesomeIcon}}}

\item{maintainColor}{Whether to maintain shape's original color}

\item{edit}{Editing enabled by default. Set to false do disable editing.}

\item{remove}{Set to false to disable removing.}

\item{selectedPathOptions}{To customize shapes in editing mode pass \code{\link{selectedPathOptions}}().}
}
\description{
Options for drawn shapes

Options for drawing polylines

Options for drawing polygons

Options for drawing rectangles

Options for drawing Circles

Options for drawing markers

Options for drawing markers

Options for path when in editMode

Options for editing shapes
}
