% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mousecoords.R
\name{addMouseCoordinates}
\alias{addMouseCoordinates}
\alias{removeMouseCoordinates}
\title{Add mouse coordinate information at top of map.}
\usage{
addMouseCoordinates(map, epsg = NULL, proj4string = NULL,
  native.crs = FALSE)

removeMouseCoordinates(map)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{epsg}{the epsg string to be shown.}

\item{proj4string}{the proj4string to be shown.}

\item{native.crs}{logical. whether to use the native crs in the coordinates box.}
}
\description{
This function adds a box displaying the current cursor location
(latitude, longitude and zoom level) at the top of a rendered
mapview or leaflet map. In case of mapview, this is automatically added.
NOTE: The information will only render once a mouse movement has happened
on the map.
}
\details{
If style is set to "detailed", the following information will be displayed:
\itemize{
  \item x: x-position of the mouse cursor in projected coordinates
  \item y: y-position of the mouse cursor in projected coordinates
  \item epsg: the epsg code of the coordinate reference system of the map
  \item proj4: the proj4 definition of the coordinate reference system of the map
  \item lat: latitude position of the mouse cursor
  \item lon: longitude position of the mouse cursor
  \item zoom: the current zoom level
}

By default, only 'lat', 'lon' and 'zoom' are shown. To show the details about
epsg, proj4 press and hold 'Ctrl' and move the mouse. 'Ctrl' + click will
copy the current contents of the box/strip at the top of the map to the clipboard,
though currently only copying of 'lon', 'lat' and 'zoom' are supported, not
'epsg' and 'proj4' as these do not change with pan and zoom.
}
\section{Functions}{
\itemize{
\item \code{removeMouseCoordinates}: remove mouse coordinates information from a map
}}

\examples{
library(leaflet)

leaflet() \%>\%
  addProviderTiles("OpenStreetMap") # without mouse position info
m = leaflet() \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addMouseCoordinates()

m

removeMouseCoordinates(m)

}
