% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get.options.metric}
\alias{get.options.metric}
\title{Get Options for Measuring Performance}
\usage{
get.options.metric(
  typesIn = character(0),
  typesOut = character(0),
  simFixSize = 10,
  trainRatio = 0.75,
  trainFixSize = 0,
  seed = 0,
  horizons = c(1L),
  weightedEval = FALSE,
  transform = NULL
)
}
\arguments{
\item{typesIn}{A list of evaluation metrics when the model is estimated using all available data. It can be \code{aic}, \code{sic}, \code{frequencyCostIn}, \code{brierIn}, or \code{aucIn}. \code{NULL} means no metric.}

\item{typesOut}{A list of evaluation metrics in a out-of-sample simulation. It can be \code{sign}, \code{direction}, \code{rmse}, \code{rmspe}, \code{mae}, \code{mape}, \code{crps}, \code{frequencyCostOut}, \code{brierOut}, or \code{aucOut}. Null means no metric.}

\item{simFixSize}{An integer that determines the number of out-of-sample simulations. Use zero to disable the simulation.}

\item{trainRatio}{A number representing the size of the training sample relative to the available size, in the out-of-sample simulation. It is effective if \code{trainFixSize} is zero.}

\item{trainFixSize}{An integer representing the number of data points in the training sample in the out-of-sample simulation. If zero, \code{trainRatio} will be used.}

\item{seed}{A seed for the random number generator. Use zero for a random value. It can be negative to get reproducible results between the \code{search.?} function and the \code{estim.?} function.}

\item{horizons}{An array of integers representing the prediction horizons to be used in out-of-sample simulations, if the model supports time-series prediction. If \code{NULL}, \code{c(1)} is used.}

\item{weightedEval}{If \code{TRUE}, weights are used in evaluating discrete-choice models.}

\item{transform}{Use a character string (e.g. \code{exp} for exponential function) or a function to transform data before calculating RMSE, MAE, RMSPE, MAPE, CRPS metrics. To disable this feature, use \code{NULL}.}
}
\value{
A list with the given options.
}
\description{
Use this function to get measuring options in \code{search.?} functions.
}
\details{
The following list describe the details of calculating the metrics:
\itemize{
\item \strong{\code{AIC}}: Akaike Information Criterion which is an estimator of the relative quality of statistical model for a given set of data.
Given a statistical model, if \eqn{k} is the number of estimated parameters and \eqn{L} is the maximized value of the likelihood function, then \eqn{AIC = 2k - 2\ln{L}}.
Smaller value for AIC means higher quality of the model.
We can convert AIC to model weight by calculating relative likelihood which is \eqn{rL = e^{0.5(AIC - min_{aic})}} where \eqn{min_{aic}} is minimum AIC value among all the candidate models. Model weight is \eqn{\frac{rL}{\sum rL}}. Since \eqn{exp(-0.5 * x)} transformation is invariant to translation, we can ignore the \eqn{min_{aic}} part.

\item \strong{\code{SIC}}: Schwarz Information Criterion which is similar to AIC.
The penalty term is larger in BIC than in AIC for sample sizes greater than 7. This means that BIC tends to favor simpler models than AIC.
Its formula as a function of the number of observations (\eqn{n}), number of parameters of the model (\eqn{k}) and the value of maximized likelihood (\eqn{L}) is \eqn{SIC = ln(n)k - 2\ln{L}}.
Smaller value for AIC means higher quality of the model.
The AIC weight discussion is valid here.

\item \strong{\code{brier}}: Brier Score which measures the accuracy of probabilistic predictions for binary outcomes.
It is calculated as the mean squared difference between the predicted probabilities and the actual outcomes.
Its formula is \eqn{B_{in} = \frac{\sum (y_i-\hat{p}_i)^2}{n}}, where \eqn{y_i} are the actual values, \eqn{\hat{p}_i} is the predicted probability that \eqn{y_i} is equal to 1, and \eqn{n} is the number of observations.
Its values are between 0 and 1. Lower values mean better predictions.
In this package, \eqn{e^{-0.5*Brier}} formula is used to convert it to weight.

\item \strong{\code{auc}}: Area Under the Receiver Operating Characteristic Curve (AUC-ROC) which measures the performance of a binary classification model.
In ROC we plot the true positive rate (sensitivity) against the false positive rate (1-specificity) at different classification thresholds. AUC is the area under the resulting curve.
Its value is between 0 and 1.
An AUC of 0 indicates that the model is perfectly incorrect, meaning that it always predicts the opposite of the true class.
An AUC of 0.5 indicates that the model is no better than random chance at distinguishing between the two classes.
An AUC of 1 indicates that the model is able to perfectly distinguish between the two classes.
In general, the higher the AUC-ROC, the better the model is at distinguishing between the two classes.
In this package, the weight of AUC is its value.

\item \strong{\code{sign}}: Sign Prediction Accuracy which reports the proportion of predictions that have the same sign as the actual values.
It is calculated as the number of correct sign predictions divided by the total number of predictions.
It is between 0 and 1, with higher values indicating better performance of the model.
Its value is used as the wight of a model.

\item \strong{\code{direction}}: Directional Prediction Accuracy which is calculated as the proportion of predictions that correctly predict the direction of change, relative to the previous observation.
It is between 0 and 1, with higher values indicating better performance of the model.
Its value is used as the wight of a model.

\item \strong{\code{rmse}}: Root Mean Squared Error which is based on the differences between the predicted values and the actual values.
Its formula is \eqn{\sqrt{\frac{1}{n}\sum_{i=1}^{n}(\hat{y}_i - y_i)^2}} where \eqn{n} is the number of observations, \eqn{y_i} is the actual values and \eqn{\hat{y}_i} is the prediction.
Lower values of RMSE indicate better model fit, with an RMSE of 0 indicating a perfect fit.
In this package, \eqn{e^{-0.5*RMSE}} formula is used to convert it to weight.

\item \strong{\code{mae}}: Mean Absolute Error which is based on the differences between the predicted values and the actual values.
Its formula is \eqn{\frac{1}{n}\sum_{i=1}^{n}|\hat{y}_i - y_i|} where \eqn{n} is the number of observations, \eqn{y_i} is the actual values and \eqn{\hat{y}_i} is the prediction.
Lower values of MAE indicate better model fit, with an MAE of 0 indicating a perfect fit.
MAE gives less weight to large errors than RMSE. This means that RMSE will be more sensitive to large errors than MAE.

\item \strong{\code{mape}}: Mean Absolute Percentage Error which is similar to MAE, but expressed as a percentage of the actual values.
Its formula is \eqn{\frac{1}{n}\sum_{i=1}^{n}|\frac{\hat{y}_i - y_i}{y_i}|\times 100} where \eqn{n} is the number of observations, \eqn{y_i} is the actual values and \eqn{\hat{y}_i} is the prediction.
MAPE can be used to compare the accuracy of forecasts across different scales, while MAE cannot.
Also note that MAE is always well-defined while MAPE is undefined if actual values are zero or negative.

\item \strong{\code{rmspe}}: Root Mean Squared Percentage Error which is similar to RMAE, but expressed as a percentage of the actual values.
Its formula is \eqn{\sqrt{\frac{1}{n}\sum_{i=1}^{n}(\frac{\hat{y}_i - y_i}{y_i})^2}\times 100} where \eqn{n} is the number of observations, \eqn{y_i} is the actual values and \eqn{\hat{y}_i} is the prediction.
RMSPE can be used to compare the accuracy of forecasts across different scales, while RMSE cannot.
Also note that RMSE is always well-defined while RMSPE is undefined if actual values are zero or negative.
Unlike MAPE, RMSPE gives more weight to large errors.

\item \strong{\code{crps}}: Continuous Ranked Probability Score which calculates the accuracy of probabilistic forecasts.
It is calculated as the mean squared difference between the predicted CDF and the empirical CDF of the observation.
Its formula is \eqn{\int_{-\infty}^{\infty}(F(y) - 1\{y \geq x\})^2dy} where \eqn{F(y)} is the predicted CDF and \eqn{1\{y \geq x\}} is the empirical CDF.
Under normality assumption (which is mainly the case in this package), the formula is \eqn{\frac{\sigma}{\sqrt{\pi}}\left(1 - 2\Phi\left(\frac{x - \mu}{\sigma}\right) + 2\frac{x - \mu}{\sigma}\phi\left(\frac{x - \mu}{\sigma}\right)\right)}.
Unlike MAE, CRPS takes into account the entire distribution of the prediction, rather than focusing on a specific point of the probability distribution.

}

Note that \code{In} at the end of the name shows that the actual values are the observations used in the estimation process.
\code{Out} shows that out-of-sample actual values is used.
}
