% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldt_survey.R
\name{CreateProject}
\alias{CreateProject}
\title{Creates JSON Data for an \code{LDTSurvey} Project}
\usage{
CreateProject(
  data,
  description = list(c("Title", "Short Description", "Long Description", "en")),
  relatedIds = list(),
  survey_IsEnabled = TRUE,
  survey_RulesChange = TRUE,
  survey_MaxHorizon = 2,
  survey_MinRequired = 1,
  survey_showAI = FALSE,
  survey_showUser = FALSE,
  survey_RestrictTo = list(),
  survey_RestrictType = c("none", "view", "submit"),
  survey_EndConditionOn = c("none", "dayOfYear", "dayOfHalfYear", "dayOfQuarter",
    "dayOfMonth", "dayOfWeek", "hourOfDay"),
  survey_EndConditionValue = 0,
  forecast_IsEnabled = TRUE,
  forecast_External = list(),
  forecast_ExternalDesc = ""
)
}
\arguments{
\item{data}{A list of Variables with consistent frequency. Use \code{Variable}
function. Target is the one with 'role:target; field or if missing, the first variable.}

\item{description}{A list of string arrays that provides basic information. Each array
provides 4 elements: 1. title of the project, 2. a short description in plain text,
3. a longer description in mark-down format, and, 4. culture-name of the information.
The first array is the default and culture-name must be unique.}

\item{relatedIds}{ID of the related projects (e.g., this can be a project with
the same data but in another frequency).}

\item{survey_IsEnabled}{If \code{FALSE}, users cannot submit prediction.}

\item{survey_RulesChange}{If \code{TRUE}, owner can change the survey rules in the future edits.}

\item{survey_MaxHorizon}{Prediction horizons. E.g., 2 means a users can submit
her prediction for the next 2 periods. It can be 1 to 5.}

\item{survey_MinRequired}{Required minimum number of data points to be predicted by a user.}

\item{survey_showAI}{If \code{TRUE}, user must submit her prediction first, before
being able to see any automatic algorithm-based forecast}

\item{survey_showUser}{If \code{TRUE}, user must submit her prediction first, before
being able to see any other user-based prediction.}

\item{survey_RestrictTo}{A list of e-mails for restricting access
(see \code{survey_RestrictType}). Leave it empty for a public page.
Otherwise, don't forget to add your email or you cannot submit prediction.}

\item{survey_RestrictType}{Type of the restriction (see \code{survey_RestrictTo}).
\code{view} means only the permitted users can view the page. \code{submit} means
everyone can view, but the permitted users can submit prediction. \code{none} means
no restriction (use it for communication purposes).}

\item{survey_EndConditionOn}{Determines the type of the condition to end a survey
automatically (see \code{survey_EndCondition}).}

\item{survey_EndConditionValue}{Determines a condition to end a survey automatically.
E.g., if \code{survey_EndConditionOn} is \code{hourOfDay} and this value is 20, the
session will end (and users cannot submit predictions) on and
after 20:00 (based on Gregorian calendar and UTC).}

\item{forecast_IsEnabled}{If \code{TRUE}, an automatic algorithm-based forecast
is reported (see also \code{survey_showAI}).}

\item{forecast_External}{An array for providing an external forecast up to
\code{survey_MaxHorizon}. A forecast should be 'up' or 'down' for a direction forecast,
a number for a point forecast, and 'dist:distribution-name(comma-separated parameters)'
for a distribution forecast (e.g., 'normal(0,1)')}

\item{forecast_ExternalDesc}{A short description on what is provided in
\code{forecast_External} (e.g., the name of the numerical method)}
}
\value{
The JSON content
}
\description{
Creates JSON Data for an \code{LDTSurvey} Project
}
