% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Kalman_smoother}
\alias{Kalman_smoother}
\title{Implement Kalman smoothing}
\usage{
Kalman_smoother(y, u, v, theta, stdlik = TRUE)
}
\arguments{
\item{y}{Observation matrix (may need to be normalized and centered before hand) (q rows, T columns)}

\item{u}{Input matrix for the state equation (m_u rows, T columns)}

\item{v}{Input matrix for the output equation (m_v rows, T columns)}

\item{theta}{A list of system parameters (A, B, C, D, Q, R)'}

\item{stdlik}{Boolean, whether the likelihood is divided by the number of observations. Standardizing the likelihood this way may speed up convergence in the case of long time series.}
}
\value{
A list of fitted elements (X, Y, V, J, and lik)
}
\description{
Estimate the hidden state and expected log-likelihood given the observations, exogeneous input and system parameters. This is an internal function and should not be called directly.
}
\section{Note}{
 This code only works on one dimensional state and output at the moment. Therefore, transposing is skipped, and matrix inversion is treated as /, and log(det(Sigma)) is treated as log(Sigma).
}

