% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.LDARep.R
\name{as.LDARep}
\alias{as.LDARep}
\alias{as.LDARep.default}
\alias{as.LDARep.LDARep}
\alias{is.LDARep}
\title{LDARep Constructor}
\usage{
as.LDARep(...)

\method{as.LDARep}{default}(lda, job, id, ...)

\method{as.LDARep}{LDARep}(x, ...)

is.LDARep(obj, verbose = FALSE)
}
\arguments{
\item{...}{additional arguments}

\item{lda}{[\code{named list}]\cr
List of \code{\link{LDA}} objects, named by the corresponding "job.id" (\code{integerish}).
If list is unnamed, names are set.}

\item{job}{[\code{\link{data.frame}} or \code{named vector}]\cr
A data.frame or data.table with named columns (at least)
"job.id" (\code{integerish}), "K", "alpha", "eta" and "num.iterations"
or a named vector with entries (at least) "K", "alpha", "eta" and "num.iterations".
If not passed, it is interpreted from \code{param} of each LDA.}

\item{id}{[\code{character(1)}]\cr
A name for the computation. If not passed, it is set to "LDARep".}

\item{x}{[\code{named list}]\cr
\code{\link{LDABatch}} or \code{\link{LDARep}} object.}

\item{obj}{[\code{R} object]\cr
Object to test.}

\item{verbose}{[\code{logical(1)}]\cr
Should test information be given in the console?}
}
\value{
[\code{named list}] with entries \code{id} for computation's name,
\code{jobs} for the parameter settings and \code{lda} for the results themselves.
}
\description{
Constructs a \code{\link{LDARep}} object for given elements \code{lda},
\code{job} and \code{id}.
}
\details{
Given a list of \code{\link{LDA}} objects the function returns
a \code{\link{LDARep}} object, which can be handled using the getter functions
at \code{\link{getJob}}.
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 7, num.iterations = 20)
lda = getLDA(res)

res2 = as.LDARep(lda, id = "newName")
res2
getJob(res2)
getJob(res)

\donttest{
batch = LDABatch(docs = reuters_docs, vocab = reuters_vocab, n = 4, id = "TEMP", K = 30)
res3 = as.LDARep(batch)
res3
getJob(res3)
}

}
\seealso{
Other constructor functions: 
\code{\link{LDA}()},
\code{\link{as.LDABatch}()}

Other replication functions: 
\code{\link{LDAPrototype}()},
\code{\link{LDARep}()},
\code{\link{getJob}()},
\code{\link{mergeRepTopics}()}
}
\concept{constructor functions}
\concept{replication functions}
