% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.lcc}
\alias{vcov.lcc}
\title{Extract Variance-Covariance Matrix of the Fixed Effects}
\usage{
\method{vcov}{lcc}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{...}{optional arguments passed to the \code{vcov.lme}
function.}
}
\value{
Returns the variance-covariance matrix of a fitted
  \code{lcc} model object.
}
\description{
Extract Variance-Covariance Matrix of the Fixed Effects
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{
\dontrun{
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
vcov(fm1)
}

}
\seealso{
\code{\link{summary.lcc}}, \code{\link{lccPlot}},
  \code{\link[lcc]{lcc}}, \code{\link{coef.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
