% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.lcc}
\alias{print.lcc}
\title{Print an \code{lcc} Object}
\usage{
\method{print}{lcc}(x, digits, ...)
}
\arguments{
\item{x}{an object inheriting from class
\code{\link[lcc]{lcc}}, representing a fitted longitudinal
concordance correlation function.}

\item{digits}{a non-null value for \code{digits} specifies the minimum
number of significant digits to be printed in values. The
default, \code{NULL}.}

\item{...}{further arguments passed to \code{{\link{print}}}.}
}
\value{
an object inheriting from class \code{print.lcc}.
}
\description{
Prints information about the longitudinal concordance
  correlation represented by an object of class
  \code{\link[lcc]{lcc}}. The returned object has a
  \code{\link[base]{print}} method.
}
\examples{
\dontrun{
## Second degree polynomial model with random intercept, slope and
## quadratic term
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
print(fm1)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link[lcc]{summary.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
