% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union.R
\name{lawn_union}
\alias{lawn_union}
\title{Merge polygons}
\usage{
lawn_union(poly1, poly2, lint = FALSE)
}
\arguments{
\item{poly1}{A \link{data-Feature}<(\link{data-Polygon})>}

\item{poly2}{A \link{data-Feature}<(\link{data-Polygon})>}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
\link{data-Feature}<(\link{data-Polygon})> or
\link{data-Feature}<(\link{data-MultiPolygon})>
}
\description{
Finds the intersection of two \link{data-Polygon}'s and returns the
union of the two
}
\details{
Contiguous polygons are combined, non-contiguous polygons
are returned as MultiPolygon.
}
\examples{
\dontrun{
poly1 <- '{
 "type": "Feature",
 "properties": {
   "fill": "#0f0"
 },
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [-122.801742, 45.48565],
     [-122.801742, 45.60491],
     [-122.584762, 45.60491],
     [-122.584762, 45.48565],
     [-122.801742, 45.48565]
    ]]
 }
}'

poly2 <- '{
 "type": "Feature",
 "properties": {
   "fill": "#00f"
 },
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [-122.520217, 45.535693],
     [-122.64038, 45.553967],
     [-122.720031, 45.526554],
     [-122.669906, 45.507309],
     [-122.723464, 45.446643],
     [-122.532577, 45.408574],
     [-122.487258, 45.477466],
     [-122.520217, 45.535693]
     ]]
 }
}'
lawn_union(poly1, poly2)

view(poly1)
view(poly2)
lawn_union(poly1, poly2) \%>\% view()

x1 <- lawn_buffer(lawn_point(c(-122.6375, 45.53)), 1500, "meters")
x2 <- lawn_buffer(lawn_point(c(-122.6475, 45.53)), 1500, "meters")
lawn_union(x1, x2)
view(x1)
view(x2)
lawn_union(x1, x2) \%>\% view()
}
}
\seealso{
\link{lawn_merge}

Other transformations: 
\code{\link{lawn_bezier}()},
\code{\link{lawn_buffer}()},
\code{\link{lawn_concave}()},
\code{\link{lawn_convex}()},
\code{\link{lawn_difference}()},
\code{\link{lawn_intersect}()},
\code{\link{lawn_merge}()},
\code{\link{lawn_simplify}()}
}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
\concept{transformations}
