% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point.R
\name{lawn_point}
\alias{lawn_point}
\title{Create a point}
\usage{
lawn_point(coordinates, properties = NULL)
}
\arguments{
\item{coordinates}{A pair of points in a vector, list or json, of the form
\code{e.g., c(longitude,latitude)}.}

\item{properties}{A list of properties. Default: NULL}
}
\value{
A \link{data-Feature}<(\link{data-Point})>
}
\description{
Create a point
}
\examples{
lawn_point(c(-74.5, 40))
lawn_point(list(-74.5, 40))
lawn_point('[-74.5, 40]')
lawn_point(c(-74.5, 40), properties = list(name = 'poly1', population = 400))

# Make a FeatureCollection
lawn_featurecollection(lawn_point(c(-74.5, 40)))
}
\seealso{
Other data functions: 
\code{\link{lawn_featurecollection}()},
\code{\link{lawn_feature}()},
\code{\link{lawn_filter}()},
\code{\link{lawn_geometrycollection}()},
\code{\link{lawn_linestring}()},
\code{\link{lawn_multilinestring}()},
\code{\link{lawn_multipoint}()},
\code{\link{lawn_multipolygon}()},
\code{\link{lawn_polygon}()},
\code{\link{lawn_random}()},
\code{\link{lawn_remove}()},
\code{\link{lawn_sample}()}
}
\concept{data functions}
