% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent.R
\name{lawn_extent}
\alias{lawn_extent}
\title{Get a bounding box}
\usage{
lawn_extent(input, lint = FALSE)
}
\arguments{
\item{input}{A \code{\link{data-Feature}} or \code{\link{data-FeatureCollection}}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
A bounding box, numeric vector of length 4
}
\description{
Calculates the extent of all input features in a FeatureCollection,
and returns a bounding box. The returned bounding box is of the form
(west, south, east, north).
}
\examples{
# From a FeatureCollection
cat(lawn_data$points_average)
lawn_extent(lawn_data$points_average)

# From a Feature
dat <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
     "type": "Polygon",
     "coordinates": [[
       [-112.072391,46.586591],
       [-112.072391,46.61761],
       [-112.028102,46.61761],
       [-112.028102,46.586591],
       [-112.072391,46.586591]
     ]]
   }
}'
lawn_extent(dat)
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bearing}}, \code{\link{lawn_center}},
  \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_size}}, \code{\link{lawn_square}}
}

