% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-modelsearch2.R
\name{merge}
\alias{merge}
\alias{merge.modelsearch2}
\title{Merge two modelsearch Objects}
\usage{
\method{merge}{modelsearch2}(x, y, ...)
}
\arguments{
\item{x}{a modelsearch2 object.}

\item{y}{a modelsearch2 object that will be added to x.}

\item{...}{not used.}
}
\description{
Merge two modelsearch objects. Does not check for meaningful result.
}
\examples{
mSim <- lvm(Y~G+X1+X2)
addvar(mSim) <- ~Z1+Z2+Z3+Z4+Z5+Z6
df.data <- lava::sim(mSim, 1e2)

mBase <- lvm(Y~G)
addvar(mBase) <- ~X1+X2+Z1+Z2+Z3+Z4+Z5+Z6
e.lvm <- estimate(mBase, data = df.data)
res.x <- modelsearch2(e.lvm, statistic = "score", method.p.adjust = "holm", nStep = 2)
res.y <- modelsearch2(getStep(res.x, slot = "sequenceModel"), 
                      statistic = "score", method.p.adjust = "holm")
res.xy <- merge(res.x,res.y)

modelsearch2(e.lvm, statistic = "score", method.p.adjust = "holm")
}
