% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{clusterTrajectories}
\alias{clusterTrajectories}
\alias{clusterTrajectories,lcModel-method}
\title{Extract cluster trajectories}
\usage{
clusterTrajectories(object, ...)

\S4method{clusterTrajectories}{lcModel}(object, at = time(object), what = "mu", ...)
}
\arguments{
\item{object}{The model.}

\item{...}{For \code{lcModel} objects: Arguments passed to \link{predict.lcModel}.}

\item{at}{A \verb{numeric vector} of the times at which to compute the cluster trajectories.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}
}
\value{
A \code{data.frame} of the estimated values at the specified times.
The first column should be named "Cluster".
The second column should be time, with the name matching the \code{timeVariable(object)}.
The third column should be the expected value of the observations, named after the \code{responseVariable(object)}.
}
\description{
Extracts a \code{data.frame} of the cluster trajectories associated with the given object.
}
\examples{
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

clusterTrajectories(model)

clusterTrajectories(model, at = c(0, .5, 1))
}
\seealso{
\link{plotClusterTrajectories}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
