% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lcModels}
\alias{lcModels}
\alias{lcModels-class}
\title{Construct a flat (named) list of lcModel objects}
\usage{
lcModels(...)
}
\arguments{
\item{...}{\code{lcModel}, \code{lcModels}, or a recursive \code{list} of \code{lcModel} objects. Arguments may be named.}
}
\value{
A \code{lcModels} object containing all specified \code{lcModel} objects.
}
\description{
The \code{lcModels} \code{S3} class represents a \code{list} of \code{lcModel} objects.
This makes it easier to work with a set of models in a more structured manner.

The \code{lcModels()} function takes the inputs and generates a named \code{lcModels} object containing a list of the input models. Duplicates are preserved.
}
\examples{
data(latrendData)
lmkmMethod <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
lmkmModel <- latrend(lmkmMethod, latrendData)
rngMethod <- lcMethodRandom("Y", id = "Id", time = "Time")
rngModel <- latrend(rngMethod, latrendData)

lcModels(lmkmModel, rngModel)

lcModels(defaults = c(lmkmModel, rngModel))
}
\seealso{
Other lcModel list functions: 
\code{\link{as.lcModels}()},
\code{\link{print.lcModels}()},
\code{\link{subset.lcModels}()}
}
\concept{lcModel list functions}
