% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{manifoldMap}
\alias{manifoldMap}
\title{Visualize an embedding by plotting with images}
\usage{
manifoldMap(x, n = nrow(x), images, scale = 1, ...)
}
\arguments{
\item{x}{A \code{largeVis} object or [N,D] matrix of coordinates.}

\item{n}{The number of images to sample.}

\item{images}{The images. A 3-D or 4-D array.}

\item{scale}{Proportion to scale the images to.}

\item{...}{Addiitional parameters passed to \code{plot}.}
}
\description{
Makes a plot of \code{n} images sampled from \code{images}, positions at coordinates given by \code{x}.
}
\details{
The images can be passed in either as a list or a 3- or 4-dimensional array. The first dimension is \code{n}.

If the objects in the list are \code{matrix} objects, or the array is 3-dimensional, the images will be treated as
greyscale. If there is an additional dimension, it must have a length of 3 and be RGB color layers.
}
\examples{
\dontrun{
load("mnist.Rda")
load("mnistcoordinates.Rda")

flip <- function(x) apply(x,2,rev)
rotate <- function(x) t(flip(x))

mnistimages <- apply(mnist$images,
   MARGIN=1,
   FUN = function(x) as.array(rotate(flip(x))))
mnistimages <- t(mnistimages)
dim(mnistimages) <- c(42000, 28, 28)

manifoldMap(coords,
   1000,
   scale = 0.07,
   mnistimages)
}
}
\references{
Andrej Karpapthy. \href{http://cs.stanford.edu/people/karpathy/cnnembed/}{t-SNE Visualization of CNN Codes.}
}
\seealso{
\code{\link{ggManifoldMap}}
}

