% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEdgeMatrix.R
\name{buildEdgeMatrix}
\alias{as_dist_edgematrix}
\alias{buildEdgeMatrix}
\title{Build an nearest-neighbor graph weighted by distance.}
\usage{
buildEdgeMatrix(data, neighbors = NULL, distance_method = "Euclidean",
  threads = NULL, verbose = getOption("verbose", TRUE), ...)

as_dist_edgematrix(x)
}
\arguments{
\item{data}{A matrix with a number of columns equal to the number of columns in `x`}

\item{neighbors}{An adjacency matrix of the type produced by \code{\link{randomProjectionTreeSearch}}. If \code{NULL}, \code{\link{randomProjectionTreeSearch}}
will be run with parameters given by \code{...}.}

\item{distance_method}{One of "Euclidean" or "Cosine"}

\item{threads}{The number of threads to use in calculating distance; set automatically if \code{NULL} (the default).}

\item{verbose}{Verbosity}

\item{...}{Additional parameters passed to \code{\link{randomProjectionTreeSearch}} if \code{neighbors} is \code{NULL}.}

\item{x}{An edge matrix.}
}
\value{
A `sparseMatrix`, with the distance method stored in attribute \code{method} and additional class `edge_matrix.`

A \code{\link[stats]{dist}} object.
}
\description{
Build an nearest-neighbor graph weighted by distance.

Convert an edge matrix to a \code{dist} object.
}
\note{
This method converts the otherwise sparse edge matrix into a dense \code{dist} object,
where any distances absent from the edge matrix are represented as \code{NA}.
}

