% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduction.R
\name{reduce_pca}
\alias{reduce_pca}
\title{Reduce Dimensionality with PCA}
\usage{
reduce_pca(
  df,
  n = NULL,
  ignore = NULL,
  comb = c(1, 2),
  quiet = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{df}{Dataframe}

\item{n}{Integer. Number of dimensions to reduce to.}

\item{ignore}{Character vector. Names of columns to ignore.}

\item{comb}{Vector. Which columns do you wish to plot? Select which
two variables by name or column position.}

\item{quiet}{Boolean. Keep quiet? If not, print messages.}

\item{plot}{Boolean. Create plots?}

\item{...}{Additional parameters passed to \code{stats::prcomp}}
}
\value{
List with reduced dataframe and possible plots.
}
\description{
Principal component analysis or (PCA) is a method we can use to
reduce high-dimensional data to a low-dimensional space. In other words,
we cannot accurately visualize high-dimensional datasets because
we cannot visualize anything above 3 features. The main purpose behind
PCA is to transform datasets with more than 3 features (high-dimensional)
into typically a 2/3 column dataset. Despite the reduction into a
lower-dimensional space we still can retain most of the variance or
information from our original dataset.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data("iris")
df <- subset(iris, select = c(-Species))
df$id <- 1:nrow(df)
reduce_pca(df, n = 3, ignore = "id")
}
\seealso{
Other Dimensionality: 
\code{\link{reduce_tsne}()}

Other Clusters: 
\code{\link{clusterKmeans}()},
\code{\link{clusterOptimalK}()},
\code{\link{clusterVisualK}()},
\code{\link{reduce_tsne}()}
}
\concept{Clusters}
\concept{Dimensionality}
