% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_hist}
\alias{stocks_hist}
\title{Download Stocks Historical Data}
\usage{
stocks_hist(
  symbols = c("VTI", "TSLA"),
  from = Sys.Date() - 365,
  to = Sys.Date(),
  today = TRUE,
  tax = 30,
  parg = FALSE,
  cache = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{symbols}{Character Vector. List of symbols to download historical data}

\item{from, to}{Date. Dates for range. If not set, 1 year will be downloaded.
Do use more than 4 days or will be over-written.}

\item{today}{Boolean. Do you wish to add today's live quote? This will happen
only if to value is the same as today's date}

\item{tax}{Numeric. How much [0-99] of your dividends are gone with taxes?}

\item{parg}{Boolean. Personal argument. Used to personalize stuff, in this
case, taxes changed from A to B in given date (hard-coded)}

\item{cache}{Boolean. Use daily cache if available?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be printed.}
}
\value{
data.frame for each Date and Symbol closing quote value.
}
\description{
This function lets the user download stocks historical data
}
\examples{
\donttest{
stocks_hist(symbols = c("VTI", "FB"), from = Sys.Date() - 7, quiet = TRUE)
}
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_quote}()},
\code{\link{trendsRelated}()},
\code{\link{writeGS}()}
}
\concept{Investment}
\concept{Scrapper}
