\name{yule.fnc}
\alias{yule.fnc}
\title{Yule's characteristic constant K}
\description{
  This function calculates Yule's characteristic constant K given a
  frequency spectrum.
}
\usage{
yule.fnc(spect)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{spect}{A frequency spectrum as generated by \code{spectrum.fnc}.}
}
\value{
  Yule's characteristic constant K
}
\references{
Yule, G. U. (1944) \emph{The Statistical Study of Literary Vocabulary},
Cambridge: Cambridge University Press.

Baayen, R. H. (2001) \emph{Word Frequency Distributions}, Dordrecht: Kluwer.
}
\author{R. H. Baayen}
\seealso{See also \code{\link{spectrum.fnc}} and \code{\link{growth.fnc}}.}
\examples{\dontrun{
  data(alice)
  yule.fnc(spectrum.fnc(alice))
}}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
