% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setGenes}
\alias{setGenes}
\title{Set genes}
\usage{
setGenes(params, dfGenes)
}
\arguments{
\item{params}{a LandsepiParams object}

\item{dfGenes}{a data.frame containing gene parameters. It can be defined manually, or,
alternatively, with \code{\link{loadGene}}.}
}
\value{
a LandsepiParams object.
}
\description{
Updates a LandsepiParams object with parameters associated with resistance genes
and pathogen adaptation.
}
\details{
dfGenes is a data.frame of parameters associated with each resistance gene and
with the evolution of each corresponding pathogenicity gene. Columns of the dataframe are:
\itemize{
\item geneName: names of resistance genes,
\item target_trait: aggressiveness components (IR, LAT, IP, or PR) targeted by resistance genes,
\item efficiency: resistance gene efficiencies, i.e. the percentage of reduction of the targeted
aggressiveness component (IR, 1/LAT, IP and PR),
\item time_to_activ_exp: expected delays to resistance activation (for APRs),
\item time_to_activ_var: variances of the delay to resistance activation (for APRs),
\item mutation_prob: mutation probabilities for pathogenicity genes (each of them
corresponding to a resistance gene),
\item Nlevels_aggressiveness: number of adaptation levels related to each resistance gene
(i.e. 1 + number of required mutations for a pathogenicity gene to fully adapt to the
corresponding resistance gene),
\item fitness_cost: fitness penalties paid by pathogen genotypes
fully adapted to the considered resistance genes on host that do not carry these genes,
\item tradeoff_strength: strengths of the trade-off relationships between the
level of aggressiveness on hosts that do and do not carry the resistance genes.
}

The data.frame must be defined as follow (example):\tabular{lllllllll}{
   geneName \tab efficiency \tab time_to_activ_exp \tab time_to_activ_var \tab mutation_prob \tab Nlevels_agressiveness \tab fitness_cost \tab tradeoff_strength \tab target_trait \cr
   MG1 \tab 1 \tab 0 \tab 0 \tab 1e-07 \tab 2 \tab 0.5 \tab 1 \tab IR \cr
   QTL1 \tab 0.5 \tab 0 \tab 0 \tab 0.0001 \tab 10 \tab 0.74 \tab 1 \tab LAT \cr
}
}
\examples{
\dontrun{
simul_params <- createSimulParams()
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene2 <- loadGene(name = "MG 2", type = "majorGene")
genes <- data.frame(rbind(gene1, gene2), stringsAsFactors = FALSE)
simul_params <- setGenes(simul_params, genes)
simul_params@Genes
}
}
\seealso{
\link{loadGene}
}
