% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_tibble2raster.R
\name{util_tibble2raster}
\alias{util_tibble2raster}
\title{Converts tibble data into a raster}
\usage{
util_tibble2raster(x)

util_tibble2raster(x)
}
\arguments{
\item{x}{a tibble}
}
\value{
Raster* object
}
\description{
Writes spatial tibble values into a raster.
}
\details{
Writes tiles with coordinates from a tibble into a raster.
Resolution is set to 1 and the extent will be c(0, max(x), 0, max(y)).

You can directly convert back the result from 'util_raster2tibble()' without
problems. If you have altered the coordinates or otherwise played with the
data, be careful while using this function.
}
\examples{
maptib <- util_raster2tibble(random_landscape)
mapras <- util_tibble2raster(maptib)
all.equal(random_landscape, mapras)

}
