% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandClass.R
\name{expandClass}
\alias{expandClass}
\title{Expand an existing class of patches.}
\usage{
expandClass(context, class, size, bgr = 0, pts = NULL)
}
\arguments{
\item{context}{SpatRaster object or matrix, an empty landscape raster or a mask indicating where the patch cannot be generated (see bgr below).}

\item{class}{The raster value of class (or patch) to expand.}

\item{size}{integer. Size of expansion, as number of raster cells.}

\item{bgr}{integer. The background available where expansion is allowed (i.e. shrinking classes).}

\item{pts}{integer or matrix. The seed point location around which the patches are built (random points are given by default). It can be an integer, as indexes of the cells in the raster, or a two columns matrix indicating x and y coordinates.}
}
\value{
A SpatRaster object. If \code{rast=FALSE} returns a list of vectors, each containing the \code{context} cells assigned to each patch.
}
\description{
Expand an existing class of patches.
}
\examples{
library(terra)

m = matrix(0, 33, 33)
r = rast(m)
ext(r) = c(0, 10, 0, 10)
r = makeClass(r, 5, 10)
plot(r)

rr = expandClass(r, 1, 100)
plot(rr)

## This function can be used to mimic shapes, by providing a skeleton:
m[,17] = 1
r = rast(m)
ext(r) = c(0, 10, 0, 10)
plot(r)

rr = expandClass(r, 1, 100)
plot(rr)
}
