% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-handling.R
\name{handle_event_error}
\alias{handle_event_error}
\title{Generate a handling function for an invocation error}
\usage{
handle_event_error(event, config, ...)
}
\value{
A function that accepts an error \code{e} as caught by
\code{\link[base]{tryCatch}}
}
\description{
An error caught during event handling must be handled in a special way. An
error message must be logged and posted to the invocation error endpoint,
and the the runtime must continue --- an invocation error is a problem for
the invocation, not the runtime.

The \code{handle_event_error} function accepts an event and generates a
function. The generated function accepts error caught by
\code{\link[base]{tryCatch}}, logs it, and then submits it to the invocation
error endpoint. Importantly it does not stop the kernel --- the intention is
that the runtime moves onto the next event.

This function may need to be implemented differently depending on the source
of an event. As such, \code{handle_event_error} is an S3 generic that can dispatch
on the event class as returned by \code{\link{classify_event}}.\if{html}{\out{<div class="sourceCode r">}}\preformatted{tryCatch(
    handle_event(...),
    error = handle_invocation_error(event) # returns a function(e)
 )
}\if{html}{\out{</div>}}
}
\keyword{internal}
