% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{thetaQQ}
\alias{thetaQQ}
\title{QQ-estimator}
\usage{
thetaQQ(x, k = NULL, x0 = NULL)
}
\arguments{
\item{x}{a numeric vector.}

\item{k}{the number of observations in the upper tail to which the Pareto
distribution is fitted.}

\item{x0}{the threshold (scale parameter) above which the Pareto distribution
is fitted.}
}
\value{
The estimated shape parameter.
}
\description{
Estimate the shape parameter of a Pareto distribution using a
quantile-quantile approach.
}
\details{
The arguments \code{k} and \code{x0} of course correspond with each other.
If \code{k} is supplied, the threshold \code{x0} is estimated with the \eqn{n
- k} largest value in \code{x}, where \eqn{n} is the number of observations.
On the other hand, if the threshold \code{x0} is supplied, \code{k} is given
by the number of observations in \code{x} larger than \code{x0}.  Therefore,
either \code{k} or \code{x0} needs to be supplied.  If both are supplied,
only \code{k} is used (mainly for back compatibility).
}
\note{
The argument \code{x0} for the threshold (scale parameter) of the
Pareto distribution was introduced in version 0.2.
}
\examples{
data(eusilc)
# equivalized disposable income is equal for each household
# member, therefore only one household member is taken
eusilc <- eusilc[!duplicated(eusilc$db030),]

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090)

# using number of observations in tail
thetaQQ(eusilc$eqIncome, k = ts$k)

# using threshold
thetaQQ(eusilc$eqIncome, x0 = ts$x0)
}
\author{
Andreas Alfons and Josef Holzer
}
\references{
Kratz, M.F. and Resnick, S.I. (1996) The QQ-estimator and heavy
tails.  \emph{Stochastic Models}, \bold{12}(4), 699--724.
}
\seealso{
\code{\link{paretoTail}}, \code{\link{fitPareto}}
}
\keyword{manip}

