% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{long2wide}
\alias{long2wide}
\title{convert a key object from long to wide format}
\usage{
long2wide(keylong)
}
\arguments{
\item{keylong}{A variable key in the long format}
}
\value{
A wide format variable key
}
\description{
##' This is not flexible, assumes columns are named in our canonical
style, which means the columns are named c("name_old", "name_new",
"class_old", "class_new", "value_old", "value_new").
}
\examples{
mydf.path <- system.file("extdata", "mydf.csv", package = "kutils")
mydf <- read.csv(mydf.path, stringsAsFactors=FALSE)
## A wide key we are trying to match:
mydf.key <- keyTemplate(mydf, long = FALSE, sort = TRUE)
mydf.key["x4", "missings"] <- "999"
## A long key we will convert next
mydf.keylong <- keyTemplate(mydf, long = TRUE, sort = TRUE)
mydf.keylong["11", "missings"] <- "999"
mydf.long2wide <- long2wide(mydf.keylong)
## Tune the rownames to match style of long key
rownames(mydf.key) <- paste0(mydf.key$name_old, ".", mydf.key$name_new)
all.equal(mydf.key, mydf.long2wide)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
