% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{assignRecode}
\alias{assignRecode}
\title{A variable is transformed in an indicated way}
\usage{
assignRecode(x, recode = NULL)
}
\arguments{
\item{x}{A column to be recoded}

\item{recode}{A character string using placeholder "x". See
examples}
}
\value{
A new column
}
\description{
In the variable key framework, the user might request
transformations such as the logarithm, exponential, or square
root. This is done by including strings in the recodes column,
such as "log(x + 1)" or "3 + 1.1 * x + 0.5 * x ^ 2". This
function implements the user's request by parsing the character
string and applying the indicated re-calculation.
}
\details{
In the variable key framework, this is applied to the raw data,
after missings are imposed.
}
\examples{
set.seed(234234)
x <- rpois(100, lambda = 3)
x <- x[order(x)]
str1 <- "log(x + 1)"
xlog <- assignRecode(x, recode = str1)
plot(xlog ~ x, type = "l")
mean(xlog, na.rm = TRUE)
str2 <- "x^2"
xsq <- assignRecode(x, recode = str2)
plot(xsq ~ x, type = "l")
str3 <- "sqrt(x)"
xsrt <- assignRecode(x, recode = str3)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}

