% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_nearest_jgd2011.R
\name{st_nearest_jgd2011}
\alias{st_nearest_jgd2011}
\alias{st_detect_jgd2011}
\title{Identify the Japan plane rectangular CS}
\usage{
st_nearest_jgd2011(geometry)

st_detect_jgd2011(geometry)
}
\arguments{
\item{geometry}{geometry (POINT, EPSG:4326)}
}
\value{
\emph{numeric} vector
}
\description{
Returns the value when the coordinates of ESPG:4326 given to the input
are replaced with those of the Japan Plane Rectangular CS.
}
\details{
\itemize{
\item \code{st_nearest_jgd2011()}: It returns the coordinate system closest to
the given ground object. This is valid even when the coordinates are at sea.
\item \code{st_detect_jgd2011()}: Identify the coordinate system in which
the given object is located.
}
}
\examples{
require("sf")
p <-
  st_sfc(sf::st_point(c(140.77, 36.8)), crs = 4326)
st_nearest_jgd2011(p)

st_detect_jgd2011(p)
st_detect_jgd2011(st_sfc(sf::st_point(c(140.73, 36.8)), crs = 4326))
}
\seealso{
\url{https://www.gsi.go.jp/LAW/heimencho.html}
}
