% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{kobePhaseMar}
\alias{kobePhaseMar}
\title{Kobe Phase Plot with Marginal Densities}
\usage{
kobePhaseMar(pts, trks = NULL, mns = FALSE, size = 1,
  xlab = expression(B:B[MSY]), ylab = expression(F:F[MSY]), xlim = 2,
  ylim = xlim, col = colorRampPalette(c("orange", "blue"), space = "Lab"),
  shade = 0.5, col2 = grey(shade), col3 = grey(shade * 1.1))
}
\arguments{
\item{pts}{data.frame with stock and harvest variables respresenting points for a year}

\item{trks}{data.frame with stock and harvest variables respresenting tracks, NULL by default}

\item{mns}{logical, do you want mean by year of pts be plotted, FALSE  by default}

\item{size}{of points1  by default}

\item{xlab}{character or expression for x axis title, expression(B:B[MSY])  by default}

\item{ylab}{character or expression for x axis title, expression(F:F[MSY])  by default}

\item{xlim}{upper limit of x axis, 2  by default}

\item{ylim}{upper limit of x axis, 2  by default}

\item{col}{colorRampPalette(c("orange","blue"),space="Lab")  by default}

\item{shade}{.5  by default}

\item{col2}{grey(shade)  by default}

\item{col3}{grey(shade*1.1)  by default}
}
\value{
a list with 3 ggplot objects, the 2 marginal densities and the phase plot
}
\description{
Plots a Kobe Phase Plot with marginal densities
'
}
\examples{
\dontrun{rnorm(10)}
}

