% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wheeler.smith.R
\name{wheeler.smith}
\alias{wheeler.smith}
\title{Readability: Wheeler-Smith Score}
\usage{
wheeler.smith(txt.file, hyphen = NULL, parameters = c(syll = 2), ...)
}
\arguments{
\item{txt.file}{Either an object of class \code{\link[koRpus]{kRp.tagged-class}},
      a character vector which must be be
a valid path to a file containing the text to be analyzed,
      or a list of text features. If the latter, calculation
is done by \code{\link[koRpus:readability.num]{readability.num}}.}

\item{hyphen}{An object of class kRp.hyphen. If \code{NULL},
      the text will be hyphenated automatically.}

\item{parameters}{A numeric vector with named magic numbers,
      defining the relevant parameters for the index.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:readability]{readability}} for details.}
}
\value{
An object of class \code{\link[koRpus]{kRp.readability-class}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:readability]{readability}}.
}
\details{
This function calculates the Wheeler-Smith Score. In contrast to
\code{\link[koRpus:readability]{readability}},
      which by default calculates all possible indices,
this function will only calculate the index value.

If \code{parameters="de"}, the calculation stays the same, but grade placement
is done according to Bamberger & Vanecek (1984), that is for german texts.
}
\examples{
\dontrun{
  wheeler.smith(tagged.text)
}
}
\references{
Bamberger, R. & Vanecek,
      E. (1984). \emph{Lesen--Verstehen--Lernen--Schreiben}. Wien: Jugend und Volk.

   Wheeler, L.R. & Smith,
      E.H. (1954). A practical readability formula for the classroom teacher in the primary grades. \emph{Elementary English},
     31, 397--399.
}
\keyword{readability}

