% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{kable}
\alias{kable}
\alias{kables}
\title{Create tables in LaTeX, HTML, Markdown and reStructuredText}
\usage{
kable(
  x,
  format,
  digits = getOption("digits"),
  row.names = NA,
  col.names = NA,
  align,
  caption = NULL,
  label = NULL,
  format.args = list(),
  escape = TRUE,
  ...
)

kables(x, format, caption = NULL, label = NULL)
}
\arguments{
\item{x}{For \code{kable()}, \code{x} is an R object, which is typically a
matrix or data frame. For \code{kables()}, a list with each element being a
returned value from \code{kable()}.}

\item{format}{A character string. Possible values are \code{latex},
\code{html}, \code{pipe} (Pandoc's pipe tables), \code{simple} (Pandoc's
simple tables), and \code{rst}. The value of this argument will be
automatically determined if the function is called within a \pkg{knitr}
document. The \code{format} value can also be set in the global option
\code{knitr.table.format}. If \code{format} is a function, it must return a
character string.}

\item{digits}{Maximum number of digits for numeric columns, passed to
\code{round()}. This can also be a vector of length \code{ncol(x)}, to set
the number of digits for individual columns.}

\item{row.names}{Logical: whether to include row names. By default, row names
are included if \code{rownames(x)} is neither \code{NULL} nor identical to
\code{1:nrow(x)}.}

\item{col.names}{A character vector of column names to be used in the table.}

\item{align}{Column alignment: a character vector consisting of \code{'l'}
(left), \code{'c'} (center) and/or \code{'r'} (right). By default or if
\code{align = NULL}, numeric columns are right-aligned, and other columns
are left-aligned. If \code{length(align) == 1L}, the string will be
expanded to a vector of individual letters, e.g. \code{'clc'} becomes
\code{c('c', 'l', 'c')}, unless the output format is LaTeX.}

\item{caption}{The table caption.}

\item{label}{The table reference label. By default, the label is obtained
from \code{knitr::\link{opts_current}$get('label')}.}

\item{format.args}{A list of arguments to be passed to \code{\link{format}()}
to format table values, e.g. \code{list(big.mark = ',')}.}

\item{escape}{Boolean; whether to escape special characters when producing
HTML or LaTeX tables. When \code{escape = FALSE}, you have to make sure
that special characters will not trigger syntax errors in LaTeX or HTML.}

\item{...}{Other arguments (see Examples).}
}
\value{
A character vector of the table source code.
}
\description{
A very simple table generator, and it is simple by design. It is not intended
to replace any other R packages for making tables. The \code{kable()}
function returns a single table for a single data object, and returns a table
that contains multiple tables if the input object is a list of data objects.
The \code{kables()} function is similar to \code{kable(x)} when \code{x} is a
list of data objects, but \code{kables()} accepts a list of \code{kable()}
values directly instead of data objects (see examples below).
}
\details{
Missing values (\code{NA}) in the table are displayed as \code{NA} by
default. If you want to display them with other characters, you can set the
option \code{knitr.kable.NA}, e.g. \code{options(knitr.kable.NA = '')} to
hide \code{NA} values.
}
\note{
When using \code{kable()} as a \emph{top-level} expression, you do not
  need to explicitly \code{print()} it due to R's automatic implicit
  printing. When it is wrapped inside other expressions (such as a
  \code{\link{for}} loop), you must explicitly \code{print(kable(...))}.
}
\examples{
d1 = head(iris)
d2 = head(mtcars)
# pipe tables by default
kable(d1)
kable(d2[, 1:5])
# no inner padding
kable(d2, format = "pipe", padding = 0)
# more padding
kable(d2, format = "pipe", padding = 2)
kable(d1, format = "latex")
kable(d1, format = "html")
kable(d1, format = "latex", caption = "Title of the table")
kable(d1, format = "html", caption = "Title of the table")
# use the booktabs package
kable(mtcars, format = "latex", booktabs = TRUE)
# use the longtable package
kable(matrix(1000, ncol = 5), format = "latex", digits = 2, longtable = TRUE)
# change LaTeX default table environment
kable(d1, format = "latex", caption = "My table", table.envir = "table*")
# add some table attributes
kable(d1, format = "html", table.attr = "id=\"mytable\"")
# reST output
kable(d2, format = "rst")
# no row names
kable(d2, format = "rst", row.names = FALSE)
# Pandoc simple tables
kable(d2, format = "simple", caption = "Title of the table")
# format numbers using , as decimal point, and ' as thousands separator
x = as.data.frame(matrix(rnorm(60, 1e+06, 10000), 10))
kable(x, format.args = list(decimal.mark = ",", big.mark = "'"))
# save the value
x = kable(d2, format = "html")
cat(x, sep = "\n")
# can also set options(knitr.table.format = 'html') so that the output is HTML

# multiple tables via either kable(list(x1, x2)) or kables(list(kable(x1),
# kable(x2)))
kable(list(d1, d2), caption = "A tale of two tables")
kables(list(kable(d1, align = "l"), kable(d2)), caption = "A tale of two tables")
}
\references{
See
  \url{https://github.com/yihui/knitr-examples/blob/master/091-knitr-table.Rnw}
   for some examples in LaTeX, but they also apply to other document formats.
}
\seealso{
Other R packages such as \pkg{huxtable}, \pkg{xtable},
  \pkg{kableExtra}, and \pkg{tables} for HTML and LaTeX tables, and
  \pkg{ascii} and \pkg{pander} for different flavors of markdown output and
  some advanced features and table styles.
}
