\name{kinresults}
\Rdversion{1.1}
\alias{kinresults}
\title{
Function to collect useful results for a set of fitted kinetic models
}
\description{
This function collects the parameters and some statistics for the fitted kinetic
models. It also generates DT50 and DT90 estimates.
}
\usage{
kinresults(kinfits, alpha = 0.05, SFORB = TRUE)
}
\arguments{
  \item{kinfits}{
The list of kinetic model(s) for which to collect results. Usually this will
have been generated by \code{\link{kinfit}}.
}
  \item{alpha}{
The confidence level chosen for the chi-squared test used in the call to
\code{\link{kinerrmin}}.
}
  \item{SFORB}{
Should the results of the \code{\link{DFOP}} model be presented as parameters
to the Single First-Order Reversible Binding (SFORB) model? }
}
\value{
A list containing a list of the parameters fitted by the models, a dataframe
containing some statistics for each of the fitted models, and a dataframe with
the resulting DT50 and DT90 values.  
}
\references{ 
  FOCUS (2006) \dQuote{Guidance Document on Estimating Persistence and
  Degradation Kinetics from Environmental Fate Studies on Pesticides in EU
  Registration} Report of the FOCUS Work Group on Degradation Kinetics,
  EC Document Reference Sanco/10058/2005 version 2.0, 434 pp,
  \url{http://focus.jrc.ec.europa.eu/dk} 
}
\author{ Johannes Ranke }
\examples{
data(FOCUS_2006_A)
kinfits <- kinfit(FOCUS_2006_A)
kinresults(kinfits)
}
\keyword{ manip }
