% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simgraph_graph.R
\name{simgraph_graph}
\alias{simgraph_graph}
\title{Simple kin dispersal simulation for graphical display. (graphs the pre-existing simulation).}
\usage{
simgraph_graph(
  result,
  nsims = 10,
  labls = TRUE,
  steps = TRUE,
  moves = TRUE,
  shadows = TRUE,
  kinship = NULL,
  show_area = TRUE,
  centred = FALSE,
  pinwheel = FALSE,
  scattered = FALSE,
  lengths = TRUE,
  lengthlabs = TRUE,
  histogram = FALSE,
  binwidth = posigma/5,
  freqpoly = FALSE
)
}
\arguments{
\item{result}{simulation supplied from simgraph_data() function (tibble)}

\item{nsims}{number of families to graph}

\item{labls}{Logical. Displays labels.}

\item{steps}{Logical. Whether or not to show any details of dispersal movement}

\item{moves}{Logical. Whether or not to show (curved) lines denoting dispersal movement}

\item{shadows}{Logical. Whether or not to show (dashed) shadows tracing dispersal movement.}

\item{kinship}{Character. Lists the kin category the simulation is reconstructing. One of "PO", "FS", "HS", "AV", "GG", "HAV", "GGG", "1C", "1C1", "2C", "GAV" (no half-categoris included)}

\item{show_area}{Logical. Whether or not to show the parental seed area as defined in data$dims}

\item{centred}{Logical. Whether or not to centre the coordinates on one individual.}

\item{pinwheel}{Logical. Whether the final graph should be of the pinwheel form.}

\item{scattered}{Logical. Whether the final graph should be of the scatter form.}

\item{lengths}{Logical. Whether or not to show a dashed line connecting the 'focus' kin to illustrate overall distance of dispersal.}

\item{lengthlabs}{Logical. Whether to show labels denoting distance of dispersal between focus kin.}

\item{histogram}{Logical. Whether the final graph should be of the histogram form.}

\item{binwidth}{Numeric. Binwidth for histogram or freqpoly.}

\item{freqpoly}{Logical. Whether the final graph should be of the freqpoly form.}
}
\value{
\preformatted{ Returns a ggplot object for graphing.
}
}
\description{
Simple kin dispersal simulation for graphical display. (graphs the pre-existing simulation).
}
\examples{
simdata <- simgraph_data()
simgraph_graph(simdata)
}
\seealso{
Other simgraph: 
\code{\link{simgraph_data}()}
}
\concept{simgraph}
